/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class ExposeExcludePropertyEndpointFilter<E extends ExposableEndpoint<?>>
implements EndpointFilter<E> {
    private final Class<E> endpointType;
    private final Set<String> include;
    private final Set<String> exclude;
    private final Set<String> exposeDefaults;

    public ExposeExcludePropertyEndpointFilter(Class<E> endpointType, Environment environment2, String prefix, String ... exposeDefaults) {
        Assert.notNull(endpointType, "EndpointType must not be null");
        Assert.notNull((Object)environment2, "Environment must not be null");
        Assert.hasText(prefix, "Prefix must not be empty");
        Binder binder = Binder.get(environment2);
        this.endpointType = endpointType;
        this.include = this.bind(binder, prefix + ".include");
        this.exclude = this.bind(binder, prefix + ".exclude");
        this.exposeDefaults = this.asSet(Arrays.asList(exposeDefaults));
    }

    public ExposeExcludePropertyEndpointFilter(Class<E> endpointType, Collection<String> include, Collection<String> exclude, String ... exposeDefaults) {
        Assert.notNull(endpointType, "EndpointType Type must not be null");
        this.endpointType = endpointType;
        this.include = this.asSet(include);
        this.exclude = this.asSet(exclude);
        this.exposeDefaults = this.asSet(Arrays.asList(exposeDefaults));
    }

    private Set<String> bind(Binder binder, String name) {
        return this.asSet(binder.bind(name, Bindable.listOf(String.class)).orElseGet(ArrayList::new));
    }

    private Set<String> asSet(Collection<String> items) {
        if (items == null) {
            return Collections.emptySet();
        }
        return items.stream().map(item -> item.toLowerCase(Locale.ENGLISH)).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public boolean match(E endpoint) {
        if (this.endpointType.isInstance(endpoint)) {
            return this.isExposed((ExposableEndpoint<?>)endpoint) && !this.isExcluded((ExposableEndpoint<?>)endpoint);
        }
        return true;
    }

    private boolean isExposed(ExposableEndpoint<?> endpoint) {
        if (this.include.isEmpty()) {
            return this.exposeDefaults.contains("*") || this.contains(this.exposeDefaults, endpoint);
        }
        return this.include.contains("*") || this.contains(this.include, endpoint);
    }

    private boolean isExcluded(ExposableEndpoint<?> endpoint) {
        if (this.exclude.isEmpty()) {
            return false;
        }
        return this.exclude.contains("*") || this.contains(this.exclude, endpoint);
    }

    private boolean contains(Set<String> items, ExposableEndpoint<?> endpoint) {
        return items.contains(endpoint.getId().toLowerCase(Locale.ENGLISH));
    }
}

