/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.text.MessageFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.LocationAwareValueMatcher;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public class ArrayValueMatcher<T>
implements LocationAwareValueMatcher<T> {
    private final JSONComparator comparator;
    private final int from;
    private final int to;

    public ArrayValueMatcher(JSONComparator comparator) {
        this(comparator, 0, Integer.MAX_VALUE);
    }

    public ArrayValueMatcher(JSONComparator comparator, int index) {
        this(comparator, index, index);
    }

    public ArrayValueMatcher(JSONComparator comparator, int from, int to) {
        assert (comparator != null) : "comparator null";
        assert (from >= 0) : MessageFormat.format("from({0}) < 0", from);
        assert (to >= from) : MessageFormat.format("to({0}) < from({1})", to, from);
        this.comparator = comparator;
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean equal(T o1, T o2) {
        return false;
    }

    @Override
    public boolean equal(String prefix, T actual, T expected, JSONCompareResult result) {
        if (!(actual instanceof JSONArray)) {
            throw new IllegalArgumentException("ArrayValueMatcher applied to non-array actual value");
        }
        try {
            JSONArray actualArray = (JSONArray)actual;
            JSONArray expectedArray = expected instanceof JSONArray ? (JSONArray)expected : new JSONArray(new Object[]{expected});
            int first = Math.max(0, this.from);
            int last = Math.min(actualArray.length() - 1, this.to);
            int expectedLen = expectedArray.length();
            for (int i = first; i <= last; ++i) {
                String elementPrefix = MessageFormat.format("{0}[{1}]", prefix, i);
                Object actualElement = actualArray.get(i);
                Object expectedElement = expectedArray.get((i - first) % expectedLen);
                this.comparator.compareValues(elementPrefix, expectedElement, actualElement, result);
            }
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }
}

