/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private String classname;

    public ObjectType(String string) {
        super((byte)14, ObjectType.toSignature(string));
        this.classname = string;
    }

    public ObjectType(String string, String string2) {
        super((byte)14, string2);
        this.classname = string;
    }

    private static String toSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("L").append(string.replace('.', '/'));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public String getClassName() {
        return this.classname;
    }

    public int hashCode() {
        return this.classname.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ObjectType ? ((ObjectType)object).classname.equals(this.classname) : false;
    }

    public boolean referencesClass() {
        JavaClass javaClass = Repository.lookupClass(this.classname);
        if (javaClass == null) {
            return false;
        }
        return javaClass.isClass();
    }

    public boolean referencesInterface() {
        JavaClass javaClass = Repository.lookupClass(this.classname);
        if (javaClass == null) {
            return false;
        }
        return !javaClass.isClass();
    }

    public boolean subclassOf(ObjectType objectType) {
        if (this.referencesInterface() || objectType.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.classname, objectType.classname);
    }

    public boolean accessibleTo(ObjectType objectType) {
        JavaClass javaClass = Repository.lookupClass(this.classname);
        if (javaClass.isPublic()) {
            return true;
        }
        JavaClass javaClass2 = Repository.lookupClass(objectType.classname);
        return javaClass2.getPackageName().equals(javaClass.getPackageName());
    }
}

