/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Utility;

public final class Code
extends Attribute {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private CodeException[] exceptionTable;
    private Attribute[] attributes;
    private static final CodeException[] NO_EXCEPTIONS = new CodeException[0];

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, null, null, constantPool);
        int n3 = dataInputStream.readInt();
        this.code = new byte[n3];
        dataInputStream.readFully(this.code);
        n3 = dataInputStream.readUnsignedShort();
        if (n3 == 0) {
            this.exceptionTable = NO_EXCEPTIONS;
        } else {
            this.exceptionTable = new CodeException[n3];
            for (int i = 0; i < n3; ++i) {
                this.exceptionTable[i] = new CodeException(dataInputStream);
            }
        }
        this.attributes = AttributeUtils.readAttributes(dataInputStream, constantPool);
        this.length = n2;
    }

    public Code(int n, int n2, int n3, int n4, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n, n2, constantPool);
        this.maxStack = n3;
        this.maxLocals = n4;
        this.setCode(byArray);
        this.setExceptionTable(codeExceptionArray);
        this.setAttributes(attributeArray);
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitCode(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(this.code.length);
        dataOutputStream.write(this.code, 0, this.code.length);
        dataOutputStream.writeShort(this.exceptionTable.length);
        for (n = 0; n < this.exceptionTable.length; ++n) {
            this.exceptionTable[n].dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.length);
        for (n = 0; n < this.attributes.length; ++n) {
            this.attributes[n].dump(dataOutputStream);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].tag != 4) continue;
            return (LineNumberTable)this.attributes[i];
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].tag != 5) continue;
            return (LocalVariableTable)this.attributes[i];
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exceptionTable;
    }

    public final int getMaxLocals() {
        return this.maxLocals;
    }

    public final int getMaxStack() {
        return this.maxStack;
    }

    private final int getInternalLength() {
        return 8 + (this.code == null ? 0 : this.code.length) + 2 + 8 * (this.exceptionTable == null ? 0 : this.exceptionTable.length) + 2;
    }

    private final int calculateLength() {
        int n = 0;
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                n += this.attributes[i].length + 6;
            }
        }
        return n + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] byArray) {
        this.code = byArray;
    }

    public final void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exceptionTable = codeExceptionArray;
    }

    public final void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    public final void setMaxStack(int n) {
        this.maxStack = n;
    }

    public final String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Code(max_stack = " + this.maxStack + ", max_locals = " + this.maxLocals + ", code_length = " + this.code.length + ")\n" + Utility.codeToString(this.code, this.cpool, 0, -1, bl));
        if (this.exceptionTable.length > 0) {
            stringBuffer.append("\nException handler(s) = \nFrom\tTo\tHandler\tType\n");
            for (n = 0; n < this.exceptionTable.length; ++n) {
                stringBuffer.append(this.exceptionTable[n].toString(this.cpool, bl) + "\n");
            }
        }
        if (this.attributes.length > 0) {
            stringBuffer.append("\nAttribute(s) = \n");
            for (n = 0; n < this.attributes.length; ++n) {
                stringBuffer.append(this.attributes[n].toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final String toString() {
        return this.toString(true);
    }

    public String getCodeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Code(max_stack = ").append(this.maxStack);
        stringBuffer.append(", max_locals = ").append(this.maxLocals);
        stringBuffer.append(", code_length = ").append(this.code.length).append(")\n");
        stringBuffer.append(Utility.codeToString(this.code, this.cpool, 0, -1, true));
        if (this.exceptionTable.length > 0) {
            stringBuffer.append("\n").append("Exception entries =  ").append(this.exceptionTable.length).append("\n");
            for (int i = 0; i < this.exceptionTable.length; ++i) {
                CodeException codeException = this.exceptionTable[i];
                int n = codeException.getCatchType();
                String string = "finally";
                if (n != 0) {
                    string = this.cpool.getConstantString(n, (byte)7);
                }
                stringBuffer.append(string).append("[");
                stringBuffer.append(codeException.getStartPC()).append(">").append(codeException.getEndPC()).append("]\n");
            }
        }
        return stringBuffer.toString();
    }
}

