/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.DataFormatException;
import io.mosip.kernel.core.util.constant.ZipUtilConstants;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    private ZipUtils() {
    }

    public static byte[] zipByteArray(byte[] input) throws io.mosip.kernel.core.exception.IOException {
        byte[] byReturn = null;
        Deflater oDeflate = new Deflater(8, false);
        oDeflate.setInput(input);
        oDeflate.finish();
        try (ByteArrayOutputStream oZipStream = new ByteArrayOutputStream();){
            while (!oDeflate.finished()) {
                byte[] byRead = new byte[1024];
                int iBytesRead = oDeflate.deflate(byRead);
                if (iBytesRead == byRead.length) {
                    oZipStream.write(byRead);
                    continue;
                }
                oZipStream.write(byRead, 0, iBytesRead);
            }
            oDeflate.end();
            byReturn = oZipStream.toByteArray();
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return byReturn;
    }

    public static byte[] unzipByteArray(byte[] input) throws io.mosip.kernel.core.exception.IOException {
        byte[] byReturn = null;
        Inflater oInflate = new Inflater(false);
        oInflate.setInput(input);
        try (ByteArrayOutputStream oZipStream = new ByteArrayOutputStream();){
            while (!oInflate.finished()) {
                byte[] byRead = new byte[1024];
                int iBytesRead = oInflate.inflate(byRead);
                if (iBytesRead == byRead.length) {
                    oZipStream.write(byRead);
                    continue;
                }
                oZipStream.write(byRead, 0, iBytesRead);
            }
            byReturn = oZipStream.toByteArray();
        }
        catch (java.util.zip.DataFormatException e) {
            throw new DataFormatException(ZipUtilConstants.DATA_FORMATE_ERROR_CODE.getErrorCode(), ZipUtilConstants.DATA_FORMATE_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return byReturn;
    }

    private static void readFile(ZipOutputStream zipOut, FileInputStream fis) throws IOException {
        int length;
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
    }

    @Deprecated
    public static boolean unZipDirectory(String zipFilePath, String destDirectory) throws Exception {
        boolean isCreated;
        File destDir = new File(destDirectory);
        String canonicalDestinationDirPath = destDir.getCanonicalPath();
        if (!destDir.exists() && !(isCreated = destDir.mkdir())) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                boolean isCreated2;
                String filePath = destDirectory + File.separator + entry.getName();
                File dir = new File(filePath);
                String canonicalDestinationFile = dir.getCanonicalPath();
                if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
                    throw new ZipException(ZipUtilConstants.ARCHIVER_ERROR_CODE.getMessage());
                }
                if (!entry.isDirectory()) {
                    isCreated2 = new File(filePath).getParentFile().mkdirs();
                    if (!isCreated2) {
                        throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
                    }
                    ZipUtils.extractFile(zipIn, filePath);
                } else {
                    isCreated2 = dir.mkdirs();
                    if (!isCreated2) {
                        throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return true;
    }

    public static boolean unZipDirectory(String zipFilePath, String destDirectory, int thresholdEntries, long thresholdSize, int thresholdRatio) throws Exception {
        boolean isCreated;
        ZipUtils.zipSlipCheck(destDirectory);
        File destDir = new File(destDirectory);
        if (!destDir.exists() && !(isCreated = destDir.mkdir())) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry zipEntry;
            int totalEntries = 0;
            long totalReadArchiveSize = 0L;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                ++totalEntries;
                Path newPath = ZipUtils.zipSlipProtect(zipEntry, Paths.get(destDir.toURI()));
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    byte[] fileSize = IOUtils.toByteArray(zipIn);
                    double compressionRatio = (double)fileSize.length / (double)zipEntry.getCompressedSize();
                    if (compressionRatio > (double)thresholdRatio) {
                        throw new ZipException(ZipUtilConstants.THRESHOLD_RATIO_EXCEPTION.getMessage());
                    }
                    if ((totalReadArchiveSize += (long)fileSize.length) > thresholdSize) {
                        throw new ZipException(ZipUtilConstants.THRESHOLD_SIZE_EXCEPTION.getMessage());
                    }
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newPath.toFile());){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zipIn.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                if (totalEntries > thresholdEntries) {
                    throw new ZipException(ZipUtilConstants.THRESHOLD_ENTRIES_EXCEPTION.getMessage());
                }
                zipIn.closeEntry();
            }
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return true;
    }

    public static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws io.mosip.kernel.core.exception.IOException, ZipException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new ZipException(ZipUtilConstants.ARCHIVER_ERROR_CODE.getMessage());
        }
        return normalizePath;
    }

    private static void zipSlipCheck(String destDirectory) throws IOException {
        String canonicalCurrentPath;
        String canonicalDestinationPath = new File(destDirectory).getCanonicalPath();
        if (!canonicalDestinationPath.contains(canonicalCurrentPath = new File(".").getCanonicalPath())) {
            throw new ZipException(ZipUtilConstants.PATH_TRAVERSAL_EXCEPTION.getMessage());
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesIn = new byte[10000];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}

