/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;

public class UUIDUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");

    private UUIDUtils() {
    }

    public static UUID getUUID(UUID namespace, String name) {
        return UUIDUtils.getUUIDFromBytes(namespace, Objects.requireNonNull(name, "name == null").getBytes(UTF8));
    }

    public static UUID getUUIDFromBytes(UUID namespace, byte[] name) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("SHA-256 not supported");
        }
        md.update(UUIDUtils.toBytes(Objects.requireNonNull(namespace, "namespace is null")));
        md.update(Objects.requireNonNull(name, "name is null"));
        byte[] sha1Bytes = md.digest();
        sha1Bytes[6] = (byte)(sha1Bytes[6] & 0xF);
        sha1Bytes[6] = (byte)(sha1Bytes[6] | 0x50);
        sha1Bytes[8] = (byte)(sha1Bytes[8] & 0x3F);
        sha1Bytes[8] = (byte)(sha1Bytes[8] | 0x80);
        return UUIDUtils.fromBytes(sha1Bytes);
    }

    private static UUID fromBytes(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length >= 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] toBytes(UUID uuid) {
        int i;
        byte[] out = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (i = 0; i < 8; ++i) {
            out[i] = (byte)(msb >> (7 - i) * 8 & 0xFFL);
        }
        for (i = 8; i < 16; ++i) {
            out[i] = (byte)(lsb >> (15 - i) * 8 & 0xFFL);
        }
        return out;
    }
}

