/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.function.ConsumerWithThrowable;
import io.mosip.kernel.core.function.FunctionWithThrowable;
import io.mosip.kernel.core.function.RunnableWithThrowable;
import io.mosip.kernel.core.function.SupplierWithThrowable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;

@Component
public class RetryUtil {
    @Autowired
    private RetryTemplate retryTemplate;

    public <R, T, E extends Throwable> R doWithRetry(FunctionWithThrowable<R, T, E> func, T t) throws E {
        return this.doProcessWithRetry(func, t);
    }

    public <R, E extends Throwable> R doWithRetry(SupplierWithThrowable<R, E> func) throws E {
        return (R)this.doProcessWithRetry(t -> func.get(), null);
    }

    public <T, E extends Throwable> void doWithRetry(ConsumerWithThrowable<T, E> func, T t) throws E {
        this.doProcessWithRetry(t1 -> {
            func.accept(t1);
            return null;
        }, t);
    }

    public <E extends Throwable> void doWithRetry(RunnableWithThrowable<E> func) throws E {
        this.doProcessWithRetry(t -> {
            func.run();
            return null;
        }, null);
    }

    private <R, T, E extends Throwable> R doProcessWithRetry(FunctionWithThrowable<R, T, E> func, T t) throws E {
        Object result = this.retryTemplate.execute(context -> func.apply(t));
        return (R)result;
    }
}

