/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.util.constant.HashUtilConstants;
import io.mosip.kernel.core.util.exception.HashUtilException;
import java.security.MessageDigest;

public class HashUtils {
    private final long multiplierConstant;
    private long total = 0L;

    public HashUtils() {
        this.multiplierConstant = 7664345821815920749L;
        this.total = 7919L;
    }

    public HashUtils(long initialOddNumber, long multiplierOddNumber) throws HashUtilException {
        if (initialOddNumber % 2L == 0L) {
            throw new HashUtilException(HashUtilConstants.MOSIP_ILLEGAL_ARGUMENT_INITIALODDNUMBER_ERROR_CODE.getErrorCode(), HashUtilConstants.MOSIP_ILLEGAL_ARGUMENT_INITIALODDNUMBER_ERROR_CODE.getErrorMessage());
        }
        if (multiplierOddNumber % 2L == 0L) {
            throw new HashUtilException(HashUtilConstants.MOSIP_ILLEGAL_ARGUMENT_MULTIPLIERODDNUMBER_ERROR_CODE.getErrorCode(), HashUtilConstants.MOSIP_ILLEGAL_ARGUMENT_MULTIPLIERODDNUMBER_ERROR_CODE.getErrorMessage());
        }
        this.multiplierConstant = multiplierOddNumber;
        this.total = initialOddNumber;
    }

    public HashUtils append(boolean value) {
        this.total = this.total * this.multiplierConstant + (value ? 0L : 1L);
        return this;
    }

    public HashUtils append(boolean[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (boolean element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(byte value) {
        this.total = this.total * this.multiplierConstant + (long)value;
        return this;
    }

    public HashUtils append(byte[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (byte element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(char value) {
        this.total = this.total * this.multiplierConstant + (long)value;
        return this;
    }

    public HashUtils append(char[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (char element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    public HashUtils append(double[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (double element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(float value) {
        this.total = this.total * this.multiplierConstant + (long)Float.floatToIntBits(value);
        return this;
    }

    public HashUtils append(float[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (float element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(int value) {
        this.total = this.total * this.multiplierConstant + (long)value;
        return this;
    }

    public HashUtils append(int[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (int element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(long value) {
        this.total = this.total * this.multiplierConstant + value;
        return this;
    }

    public HashUtils append(long[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (long element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(Object value) {
        if (value == null) {
            this.total *= this.multiplierConstant;
        } else if (value.getClass().isArray()) {
            this.appendArray(value);
        } else if (value instanceof String) {
            char[] chr = ((String)value).toCharArray();
            this.append(chr);
        } else {
            this.total = this.total * this.multiplierConstant + (long)value.hashCode();
        }
        return this;
    }

    private void appendArray(Object object) {
        if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
    }

    public HashUtils append(Object[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (Object element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public HashUtils append(short value) {
        this.total = this.total * this.multiplierConstant + (long)value;
        return this;
    }

    public HashUtils append(short[] array) {
        if (array == null) {
            this.total *= this.multiplierConstant;
        } else {
            for (short element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public long build() {
        return this.toHashCode();
    }

    public long toHashCode() {
        return this.total;
    }

    public boolean isDigestEqual(byte[] source, byte[] target) {
        return MessageDigest.isEqual(source, target);
    }
}

