/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.util.constant.HMACUtilConstants;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;

@Deprecated
public final class HMACUtils {
    private static final String HMAC_ALGORITHM_NAME = "SHA-256";
    private static MessageDigest messageDigest;

    public static synchronized byte[] generateHash(byte[] bytes) {
        return messageDigest.digest(bytes);
    }

    public static void update(byte[] bytes) {
        messageDigest.update(bytes);
    }

    public static byte[] updatedHash() {
        return messageDigest.digest();
    }

    public static synchronized String digestAsPlainTextWithSalt(byte[] password, byte[] salt) {
        messageDigest.update(password);
        messageDigest.update(salt);
        return DatatypeConverter.printHexBinary(messageDigest.digest());
    }

    public static synchronized String digestAsPlainText(byte[] bytes) {
        return DatatypeConverter.printHexBinary(bytes).toUpperCase();
    }

    public static byte[] generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        return randomBytes;
    }

    public static byte[] generateSalt(int bytes) {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[bytes];
        random.nextBytes(randomBytes);
        return randomBytes;
    }

    public static String encodeBase64String(byte[] data) {
        return Base64.encodeBase64String(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decodeBase64(data);
    }

    private HMACUtils() {
    }

    private static String encode(String password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), Base64.decodeBase64(salt), 27500, 512);
        try {
            byte[] key = HMACUtils.getSecretKeyFactory().generateSecret(spec).getEncoded();
            return Base64.encodeBase64String(key);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Credential could not be encoded", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SecretKeyFactory getSecretKeyFactory() throws java.security.NoSuchAlgorithmException {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PBKDF2 algorithm not found", e);
        }
    }

    static {
        try {
            messageDigest = messageDigest != null ? messageDigest : MessageDigest.getInstance(HMAC_ALGORITHM_NAME);
        }
        catch (java.security.NoSuchAlgorithmException exception) {
            throw new NoSuchAlgorithmException(HMACUtilConstants.MOSIP_NO_SUCH_ALGORITHM_ERROR_CODE.getErrorCode(), HMACUtilConstants.MOSIP_NO_SUCH_ALGORITHM_ERROR_CODE.getErrorMessage(), exception.getCause());
        }
    }
}

