/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.IllegalArgumentException;
import io.mosip.kernel.core.exception.NullPointerException;
import io.mosip.kernel.core.exception.ParseException;
import io.mosip.kernel.core.util.constant.DateUtilConstants;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;

public final class DateUtils {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private DateUtils() {
    }

    public static Date addDays(Date date, int days) {
        try {
            return org.apache.commons.lang3.time.DateUtils.addDays(date, days);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static Date addHours(Date date, int hours) {
        try {
            return org.apache.commons.lang3.time.DateUtils.addHours(date, hours);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static Date addMinutes(Date date, int minutes) {
        try {
            return org.apache.commons.lang3.time.DateUtils.addMinutes(date, minutes);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static Date addSeconds(Date date, int seconds) {
        try {
            return org.apache.commons.lang3.time.DateUtils.addSeconds(date, seconds);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatDate(Date date, String pattern) {
        try {
            return DateFormatUtils.format(date, pattern, null, null);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatDate(Date date, String pattern, TimeZone timeZone) {
        try {
            return DateFormatUtils.format(date, pattern, timeZone, null);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatDate(Date date, String pattern, TimeZone timeZone, Locale locale) {
        try {
            return DateFormatUtils.format(date, pattern, timeZone, locale);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatCalendar(Calendar calendar, String pattern) {
        try {
            return DateFormatUtils.format(calendar, pattern, null, null);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatCalendar(Calendar calendar, String pattern, TimeZone timeZone) {
        try {
            return DateFormatUtils.format(calendar, pattern, timeZone, null);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatCalendar(Calendar calendar, String pattern, Locale locale) {
        try {
            return DateFormatUtils.format(calendar, pattern, null, locale);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String formatCalendar(Calendar calendar, String pattern, TimeZone timeZone, Locale locale) {
        try {
            return DateFormatUtils.format(calendar, pattern, timeZone, locale);
        }
        catch (java.lang.IllegalArgumentException | java.lang.NullPointerException e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean after(Date d1, Date d2) {
        try {
            return d1.after(d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean before(Date d1, Date d2) {
        try {
            return d1.before(d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean isSameDay(Date d1, Date d2) {
        try {
            return org.apache.commons.lang3.time.DateUtils.isSameDay(d1, d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean isSameInstant(Date d1, Date d2) {
        try {
            return org.apache.commons.lang3.time.DateUtils.isSameInstant(d1, d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean after(LocalDateTime d1, LocalDateTime d2) {
        try {
            return d1.isAfter(d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean before(LocalDateTime d1, LocalDateTime d2) {
        try {
            return d1.isBefore(d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean isSameDay(LocalDateTime d1, LocalDateTime d2) {
        try {
            return d1.toLocalDate().isEqual(d2.toLocalDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean isSameInstant(LocalDateTime d1, LocalDateTime d2) {
        try {
            return d1.isEqual(d2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String toISOString(LocalDateTime localDateTime) {
        ZonedDateTime zonedtime = localDateTime.atZone(ZoneId.systemDefault());
        ZonedDateTime converted = zonedtime.withZoneSameInstant(ZoneOffset.UTC);
        return converted.toString();
    }

    public static String toISOString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(UTC_DATETIME_PATTERN);
        df.setTimeZone(UTC_TIME_ZONE);
        return df.format(date);
    }

    public static String formatToISOString(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }

    public static LocalDateTime getUTCCurrentDateTime() {
        return ZonedDateTime.now(ZoneOffset.UTC).toLocalDateTime();
    }

    public static String getUTCCurrentDateTimeString() {
        return OffsetDateTime.now().toInstant().toString();
    }

    public static String getUTCCurrentDateTimeString(String pattern) {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getCurrentDateTimeString() {
        return OffsetDateTime.now().toString();
    }

    public static LocalDateTime convertUTCToLocalDateTime(String utcDateTime) {
        return ZonedDateTime.parse(utcDateTime).toLocalDateTime();
    }

    public static LocalDateTime parseUTCToLocalDateTime(String utcDateTime) {
        OffsetDateTime odt = OffsetDateTime.parse(utcDateTime);
        return odt.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime parseToLocalDateTime(String dateTime) {
        try {
            return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
        }
        catch (Exception e) {
            return LocalDateTime.parse(dateTime);
        }
    }

    public static LocalDateTime parseUTCToLocalDateTime(String utcDateTime, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
        try {
            return simpleDateFormat.parse(utcDateTime).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (java.text.ParseException e) {
            throw new ParseException(DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getErrorCode(), DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getEexceptionMessage(), e);
        }
    }

    public static LocalDateTime parseDateToLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date parseUTCToDate(String utcDateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UTC_DATETIME_PATTERN);
        simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
        try {
            return simpleDateFormat.parse(utcDateTime);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getErrorCode(), DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getEexceptionMessage(), e);
        }
    }

    public static Date parseUTCToDate(String utcDateTime, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
        try {
            return simpleDateFormat.parse(utcDateTime);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getErrorCode(), DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getEexceptionMessage(), e);
        }
    }

    public static Date parseToDate(String dateTime, String pattern, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(timeZone);
        try {
            return simpleDateFormat.parse(dateTime);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getErrorCode(), DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getEexceptionMessage(), e);
        }
    }

    public static Date parseToDate(String dateString, String pattern) {
        if (Objects.isNull(dateString) || Objects.isNull(pattern)) {
            throw new NullPointerException(DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), DateUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), new java.lang.NullPointerException("dateString or dateFormat is null"));
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            throw new ParseException(DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getErrorCode(), DateUtilConstants.PARSE_EXCEPTION_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static String getUTCTimeFromDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(UTC_DATETIME_PATTERN);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(UTC_ZONE_ID));
        return dateFormatter.format(date);
    }
}

