/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.IllegalArgumentException;
import io.mosip.kernel.core.exception.NullPointerException;
import io.mosip.kernel.core.util.constant.CalendarUtilConstants;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;

public final class CalendarUtils {
    private CalendarUtils() {
    }

    public static Calendar getCeiling(Calendar calendar, int field) {
        try {
            return DateUtils.ceiling(calendar, field);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
        catch (ArithmeticException exception) {
            throw new io.mosip.kernel.core.exception.ArithmeticException(CalendarUtilConstants.ARITHMETIC_EXCEPTION_CODE.getErrorCode(), CalendarUtilConstants.YEAR_OVERFLOW_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static long getFragmentInDays(Calendar calendar, int fragment) {
        try {
            return DateUtils.getFragmentInDays(calendar, fragment);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static long getFragmentInHours(Calendar calendar, int fragment) {
        try {
            return DateUtils.getFragmentInHours(calendar, fragment);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int fragment) {
        try {
            return DateUtils.getFragmentInMilliseconds(calendar, fragment);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static long getFragmentInMinutes(Calendar calendar, int fragment) {
        try {
            return DateUtils.getFragmentInMinutes(calendar, fragment);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static long getFragmentInSeconds(Calendar calendar, int fragment) {
        try {
            return DateUtils.getFragmentInSeconds(calendar, fragment);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        try {
            return DateUtils.isSameDay(cal1, cal2);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static boolean isSameInstant(Calendar cal1, Calendar cal2) {
        try {
            return DateUtils.isSameInstant(cal1, cal2);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static boolean isSameLocalTime(Calendar cal1, Calendar cal2) {
        try {
            return DateUtils.isSameLocalTime(cal1, cal2);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static Calendar getRound(Calendar calendar, int field) {
        try {
            return DateUtils.round(calendar, field);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
        catch (ArithmeticException exception) {
            throw new io.mosip.kernel.core.exception.ArithmeticException(CalendarUtilConstants.ARITHMETIC_EXCEPTION_CODE.getErrorCode(), CalendarUtilConstants.YEAR_OVERFLOW_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static Calendar toCalendar(Date date) {
        try {
            return DateUtils.toCalendar(date);
        }
        catch (java.lang.NullPointerException exception) {
            throw new NullPointerException(CalendarUtilConstants.NULL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.DATE_NULL_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        try {
            return DateUtils.toCalendar(date, tz);
        }
        catch (java.lang.NullPointerException exception) {
            throw new NullPointerException(CalendarUtilConstants.NULL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.DATE_NULL_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static Calendar truncate(Calendar date, int field) {
        try {
            return DateUtils.truncate(date, field);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
        catch (ArithmeticException exception) {
            throw new io.mosip.kernel.core.exception.ArithmeticException(CalendarUtilConstants.ARITHMETIC_EXCEPTION_CODE.getErrorCode(), CalendarUtilConstants.YEAR_OVERFLOW_MESSAGE.getErrorCode(), exception.getCause());
        }
    }

    public static boolean truncatedEquals(Calendar cal1, Calendar cal2, int field) {
        try {
            return DateUtils.truncatedEquals(cal1, cal2, field);
        }
        catch (java.lang.IllegalArgumentException exception) {
            throw new IllegalArgumentException(CalendarUtilConstants.ILLEGAL_ARGUMENT_CODE.getErrorCode(), CalendarUtilConstants.ILLEGAL_ARGUMENT_MESSAGE.getErrorCode(), exception.getCause());
        }
    }
}

