/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.retry;

import io.mosip.kernel.core.exception.ExceptionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.env.Environment;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableAspectJAutoProxy
public class RetryConfig {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String DEFAULT_RETRYABLE_EXCEPTIONS = Exception.class.getName();
    private static final String DEFAULT_NONRETRYABLE_EXCEPTIONS = Runtime.class.getName();
    @Autowired
    private Environment environment;

    @Bean
    public RetryPolicy retryPolicy(@Value(value="${kernel.retry.attempts.limit:5}") int retryLimit, @Value(value="${kernel.retry.traverse.root.cause.enabled:true}") boolean traverseRootCause) {
        int maxAttempts = retryLimit + 1;
        Map<Class<? extends Throwable>, Boolean> retryableExceptions = this.getRetryableExceptionsFromConfig();
        SimpleRetryPolicy simpleRetryPolicyForInclusiveExceptions = new SimpleRetryPolicy(maxAttempts, retryableExceptions, traverseRootCause, false);
        Map<Class<? extends Throwable>, Boolean> nonRetryableExceptions = this.getNonRetryableExceptionsFromConfig();
        SimpleRetryPolicy simpleRetryPolicyForExclusiveExceptions = new SimpleRetryPolicy(maxAttempts, nonRetryableExceptions, traverseRootCause, true);
        CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
        compositeRetryPolicy.setOptimistic(false);
        compositeRetryPolicy.setPolicies(new RetryPolicy[]{simpleRetryPolicyForInclusiveExceptions, simpleRetryPolicyForExclusiveExceptions});
        return compositeRetryPolicy;
    }

    protected Map<Class<? extends Throwable>, Boolean> getRetryableExceptionsFromConfig() {
        return this.getExceptionsMapFromConfig("kernel.retry.retryable.exceptions", DEFAULT_RETRYABLE_EXCEPTIONS, true);
    }

    private Map<Class<? extends Throwable>, Boolean> getNonRetryableExceptionsFromConfig() {
        return this.getExceptionsMapFromConfig("kernel.retry.nonretryable.exceptions", DEFAULT_NONRETRYABLE_EXCEPTIONS, false);
    }

    private Map<Class<? extends Throwable>, Boolean> getExceptionsMapFromConfig(String configProperty, String defaulPropValue, boolean shouldRetry) {
        String propertyValue = this.environment.getProperty(configProperty, defaulPropValue);
        return Stream.of(propertyValue.split(",")).filter(str -> !str.isEmpty()).map(str -> {
            try {
                return Class.forName(str);
            }
            catch (ClassNotFoundException e) {
                logger.error("", this.getClass().getSimpleName(), "getExceptionsMapFromConfig", e.getMessage(), e);
                return null;
            }
        }).filter(Objects::nonNull).filter(cl -> Throwable.class.isAssignableFrom((Class<?>)cl)).map(cl -> cl).collect(Collectors.toMap(Function.identity(), arg -> shouldRetry));
    }

    @Bean
    public BackOffPolicy backOffPolicy(@Value(value="${kernel.retry.exponential.backoff.initial.interval.millisecs:200}") long initialIntervalMilliSecs, @Value(value="${kernel.retry.exponential.backoff.multiplier:1.0}") double multiplier, @Value(value="${kernel.retry.exponential.backoff.max.interval.millisecs:5000}") long maxIntervalMilliSecs) {
        ExponentialBackOffPolicy exponentialBackOffPolicy = new ExponentialBackOffPolicy();
        exponentialBackOffPolicy.setInitialInterval(initialIntervalMilliSecs);
        exponentialBackOffPolicy.setMultiplier(multiplier);
        exponentialBackOffPolicy.setMaxInterval(maxIntervalMilliSecs);
        return exponentialBackOffPolicy;
    }

    @Bean
    public RetryTemplate retryTemplate(RetryPolicy retryPolicy, BackOffPolicy backOffPolicy, RetryListener retryListener) {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy(retryPolicy);
        retryTemplate.setBackOffPolicy(backOffPolicy);
        retryTemplate.setThrowLastExceptionOnExhausted(true);
        retryTemplate.setListeners(new RetryListener[]{retryListener});
        return retryTemplate;
    }
}

