/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.masterdata.util.spi;

import io.mosip.kernel.core.masterdata.util.model.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public interface UBtree<T> {
    default public List<Node<T>> createTree(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        HashMap<String, Node> mapTmp = new HashMap<String, Node>();
        List<Node<T>> nodes = list.stream().map(this::convertToNode).collect(Collectors.toList());
        for (Node node : nodes) {
            mapTmp.put(node.getId(), node);
        }
        for (Node node : nodes) {
            Node parent;
            String parentId = node.getParentId();
            if (parentId == null || (parent = (Node)mapTmp.get(parentId)) == null) continue;
            node.setParent(parent);
            parent.addChild(node);
            mapTmp.put(parentId, parent);
            mapTmp.put(node.getId(), node);
        }
        return nodes;
    }

    default public List<Node<T>> findLeafs(Node<T> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<Node<T>> flatList = new ArrayList<Node<T>>();
        ArrayDeque q = new ArrayDeque();
        q.addLast(node);
        while (!q.isEmpty()) {
            Node n = (Node)q.removeLast();
            List children = n.getChilds();
            if (children != null) {
                for (Node child : children) {
                    q.addLast(child);
                }
                continue;
            }
            flatList.add(n);
        }
        return flatList;
    }

    default public List<T> findLeafsValue(Node<T> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        List<Node<T>> nodes = this.findLeafs(node);
        return nodes.stream().map(Node::getValue).collect(Collectors.toList());
    }

    default public Node<T> findRootNode(Node<T> node) {
        if (node == null) {
            return node;
        }
        Node<T> root = node;
        boolean flag = true;
        while (flag) {
            if (root.getParent() != null) {
                root = root.getParent();
                continue;
            }
            flag = false;
        }
        return root;
    }

    default public T findRootNodeValue(Node<T> node) {
        if (node == null) {
            return null;
        }
        return this.findRootNode(node).getValue();
    }

    default public List<T> getChildHierarchy(Node<T> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList flatList = new ArrayList();
        ArrayDeque q = new ArrayDeque();
        q.addLast(node);
        flatList.add(node.getValue());
        while (!q.isEmpty()) {
            Node n = (Node)q.removeLast();
            List children = n.getChilds();
            if (children == null) continue;
            for (Node child : children) {
                q.addLast(child);
                flatList.add(child.getValue());
            }
        }
        return flatList;
    }

    default public List<T> getParentHierarchy(Node<T> node) {
        Objects.requireNonNull(node);
        ArrayList<T> data = new ArrayList<T>();
        Node<T> root = node;
        data.add(node.getValue());
        boolean flag = true;
        while (flag) {
            if (root.getParent() != null) {
                root = root.getParent();
                data.add(root.getValue());
                continue;
            }
            flag = false;
        }
        return data;
    }

    default public Node<T> searchNode(Node<T> root, String id) {
        if (root == null) {
            return null;
        }
        ArrayDeque q = new ArrayDeque();
        q.addLast(root);
        while (!q.isEmpty()) {
            Node n = (Node)q.removeLast();
            if (n.getId().equals(id)) {
                return n;
            }
            List children = n.getChilds();
            if (children == null) continue;
            for (Node child : children) {
                q.addLast(child);
            }
        }
        return null;
    }

    default public Node<T> findNode(List<Node<T>> list, String id) {
        Optional<Node> node = list.stream().filter(i -> i.getId().equals(id)).findAny();
        return node.isPresent() ? node.get() : null;
    }

    public Node<T> convertToNode(T var1);
}

