/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.cbeffutil.entity;

import io.mosip.kernel.core.cbeffutil.entity.BDBInfo;
import io.mosip.kernel.core.cbeffutil.entity.BIRInfo;
import io.mosip.kernel.core.cbeffutil.entity.BIRVersion;
import io.mosip.kernel.core.cbeffutil.entity.SBInfo;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BIRType;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import lombok.Generated;

public class BIR {
    private BIRVersion version;
    private BIRVersion cbeffversion;
    private BIRInfo birInfo;
    private BDBInfo bdbInfo;
    private byte[] bdb;
    private byte[] sb;
    private SBInfo sbInfo;
    private List<JAXBElement<String>> element;

    public BIR(BIRBuilder birBuilder) {
        this.version = birBuilder.version;
        this.cbeffversion = birBuilder.cbeffversion;
        this.birInfo = birBuilder.birInfo;
        this.bdbInfo = birBuilder.bdbInfo;
        this.bdb = birBuilder.bdb;
        this.sb = birBuilder.sb;
        this.sbInfo = birBuilder.sbInfo;
        this.element = birBuilder.element;
    }

    public List<JAXBElement<String>> getElement() {
        return this.element;
    }

    public BIRVersion getVersion() {
        return this.version;
    }

    public BIRVersion getCbeffversion() {
        return this.cbeffversion;
    }

    public BIRInfo getBirInfo() {
        return this.birInfo;
    }

    public BDBInfo getBdbInfo() {
        return this.bdbInfo;
    }

    public byte[] getBdb() {
        return this.bdb;
    }

    public byte[] getSb() {
        return this.sb;
    }

    public SBInfo getSbInfo() {
        return this.sbInfo;
    }

    public BIRType toBIRType(BIR bir) {
        BIRType bIRType = new BIRType();
        if (bir.getVersion() != null) {
            bIRType.setVersion(bir.getVersion().toVersion());
        }
        if (bir.getCbeffversion() != null) {
            bIRType.setCBEFFVersion(bir.getCbeffversion().toVersion());
        }
        bIRType.setBDB(this.getBdb());
        bIRType.setSB(this.getSb());
        if (bir.getBirInfo() != null) {
            bIRType.setBIRInfo(bir.getBirInfo().toBIRInfo());
        }
        if (bir.getBdbInfo() != null) {
            bIRType.setBDBInfo(bir.getBdbInfo().toBDBInfo());
        }
        if (bir.getSbInfo() != null) {
            bIRType.setSBInfo(bir.getSbInfo().toSBInfoType());
        }
        if (bir.getElement() != null) {
            bIRType.setAny(this.getElement());
        }
        return bIRType;
    }

    @Generated
    public void setVersion(BIRVersion version) {
        this.version = version;
    }

    @Generated
    public void setCbeffversion(BIRVersion cbeffversion) {
        this.cbeffversion = cbeffversion;
    }

    @Generated
    public void setBirInfo(BIRInfo birInfo) {
        this.birInfo = birInfo;
    }

    @Generated
    public void setBdbInfo(BDBInfo bdbInfo) {
        this.bdbInfo = bdbInfo;
    }

    @Generated
    public void setBdb(byte[] bdb) {
        this.bdb = bdb;
    }

    @Generated
    public void setSb(byte[] sb) {
        this.sb = sb;
    }

    @Generated
    public void setSbInfo(SBInfo sbInfo) {
        this.sbInfo = sbInfo;
    }

    @Generated
    public void setElement(List<JAXBElement<String>> element) {
        this.element = element;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BIR)) {
            return false;
        }
        BIR other = (BIR)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BIRVersion this$version = this.getVersion();
        BIRVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        BIRVersion this$cbeffversion = this.getCbeffversion();
        BIRVersion other$cbeffversion = other.getCbeffversion();
        if (this$cbeffversion == null ? other$cbeffversion != null : !((Object)this$cbeffversion).equals(other$cbeffversion)) {
            return false;
        }
        BIRInfo this$birInfo = this.getBirInfo();
        BIRInfo other$birInfo = other.getBirInfo();
        if (this$birInfo == null ? other$birInfo != null : !((Object)this$birInfo).equals(other$birInfo)) {
            return false;
        }
        BDBInfo this$bdbInfo = this.getBdbInfo();
        BDBInfo other$bdbInfo = other.getBdbInfo();
        if (this$bdbInfo == null ? other$bdbInfo != null : !((Object)this$bdbInfo).equals(other$bdbInfo)) {
            return false;
        }
        if (!Arrays.equals(this.getBdb(), other.getBdb())) {
            return false;
        }
        if (!Arrays.equals(this.getSb(), other.getSb())) {
            return false;
        }
        SBInfo this$sbInfo = this.getSbInfo();
        SBInfo other$sbInfo = other.getSbInfo();
        if (this$sbInfo == null ? other$sbInfo != null : !((Object)this$sbInfo).equals(other$sbInfo)) {
            return false;
        }
        List<JAXBElement<String>> this$element = this.getElement();
        List<JAXBElement<String>> other$element = other.getElement();
        return !(this$element == null ? other$element != null : !((Object)this$element).equals(other$element));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BIR;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BIRVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        BIRVersion $cbeffversion = this.getCbeffversion();
        result = result * 59 + ($cbeffversion == null ? 43 : ((Object)$cbeffversion).hashCode());
        BIRInfo $birInfo = this.getBirInfo();
        result = result * 59 + ($birInfo == null ? 43 : ((Object)$birInfo).hashCode());
        BDBInfo $bdbInfo = this.getBdbInfo();
        result = result * 59 + ($bdbInfo == null ? 43 : ((Object)$bdbInfo).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBdb());
        result = result * 59 + Arrays.hashCode(this.getSb());
        SBInfo $sbInfo = this.getSbInfo();
        result = result * 59 + ($sbInfo == null ? 43 : ((Object)$sbInfo).hashCode());
        List<JAXBElement<String>> $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BIR(version=" + this.getVersion() + ", cbeffversion=" + this.getCbeffversion() + ", birInfo=" + this.getBirInfo() + ", bdbInfo=" + this.getBdbInfo() + ", bdb=" + Arrays.toString(this.getBdb()) + ", sb=" + Arrays.toString(this.getSb()) + ", sbInfo=" + this.getSbInfo() + ", element=" + this.getElement() + ")";
    }

    @Generated
    public BIR() {
    }

    public static class BIRBuilder {
        private BIRVersion version;
        private BIRVersion cbeffversion;
        private BIRInfo birInfo;
        private BDBInfo bdbInfo;
        private byte[] bdb;
        private byte[] sb;
        private SBInfo sbInfo;
        private List<JAXBElement<String>> element;

        public BIRBuilder withElement(List<JAXBElement<String>> list) {
            this.element = list;
            return this;
        }

        public BIRBuilder withVersion(BIRVersion version) {
            this.version = version;
            return this;
        }

        public BIRBuilder withCbeffversion(BIRVersion cbeffversion) {
            this.cbeffversion = cbeffversion;
            return this;
        }

        public BIRBuilder withBirInfo(BIRInfo birInfo) {
            this.birInfo = birInfo;
            return this;
        }

        public BIRBuilder withBdbInfo(BDBInfo bdbInfo) {
            this.bdbInfo = bdbInfo;
            return this;
        }

        public BIRBuilder withBdb(byte[] bdb) {
            this.bdb = bdb;
            return this;
        }

        public BIRBuilder withSb(byte[] sb) {
            this.sb = sb;
            return this;
        }

        public BIRBuilder withSbInfo(SBInfo sbInfo) {
            this.sbInfo = sbInfo;
            return this;
        }

        public BIR build() {
            return new BIR(this);
        }
    }
}

