/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableBooleanFieldProperty
extends OptimizedSettableBeanProperty<SettableBooleanFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableBooleanFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableBooleanFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        JsonToken t = p.getCurrentToken();
        boolean b = t == JsonToken.VALUE_TRUE ? true : (t == JsonToken.VALUE_FALSE ? false : this._deserializeBoolean(p, ctxt));
        try {
            this._propertyMutator.booleanField(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, b, e);
        }
    }

    @Override
    public void set(Object bean2, Object value) throws IOException {
        boolean b = (Boolean)value;
        try {
            this._propertyMutator.booleanField(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, b, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        JsonToken t = p.getCurrentToken();
        boolean b = t == JsonToken.VALUE_TRUE ? true : (t == JsonToken.VALUE_FALSE ? false : this._deserializeBoolean(p, ctxt));
        return this.setAndReturn(instance, b);
    }
}

