/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedValueInstantiator;
import com.fasterxml.jackson.module.afterburner.util.ClassName;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CreatorOptimizer
extends DynamicPropertyAccessorBase {
    protected final Class<?> _valueClass;
    protected final MyClassLoader _classLoader;
    protected final StdValueInstantiator _originalInstantiator;

    public CreatorOptimizer(Class<?> valueClass, MyClassLoader classLoader, StdValueInstantiator orig) {
        this._valueClass = valueClass;
        this._classLoader = classLoader;
        this._originalInstantiator = orig;
    }

    public ValueInstantiator createOptimized() {
        if (this._originalInstantiator.canCreateFromObjectWith() || this._originalInstantiator.canCreateUsingDelegate()) {
            return null;
        }
        AnnotatedWithParams defaultCreator = this._originalInstantiator.getDefaultCreator();
        if (defaultCreator != null) {
            Method m;
            int mods;
            AnnotatedElement elem = defaultCreator.getAnnotated();
            if (elem instanceof Constructor) {
                Constructor ctor = (Constructor)elem;
                if (!Modifier.isPrivate(ctor.getModifiers())) {
                    return this.createSubclass(ctor, null).with(this._originalInstantiator);
                }
            } else if (elem instanceof Method && Modifier.isStatic(mods = (m = (Method)elem).getModifiers()) && !Modifier.isPrivate(mods)) {
                return this.createSubclass(null, m).with(this._originalInstantiator);
            }
        }
        return null;
    }

    protected OptimizedValueInstantiator createSubclass(Constructor<?> ctor, Method factory) {
        MyClassLoader loader = this._classLoader == null ? new MyClassLoader(this._valueClass.getClassLoader(), true) : this._classLoader;
        ClassName baseName = ClassName.constructFor(this._valueClass, "$Creator4JacksonDeserializer");
        byte[] bytecode = this.generateOptimized(baseName, ctor, factory);
        baseName.assignChecksum(bytecode);
        Class<?> impl = null;
        try {
            impl = loader.loadClass(baseName.getDottedName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (impl == null) {
            impl = loader.loadAndResolve(baseName, bytecode);
        }
        try {
            return (OptimizedValueInstantiator)impl.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + baseName + "': " + e.getMessage(), e);
        }
    }

    protected byte[] generateOptimized(ClassName baseName, Constructor<?> ctor, Method factory) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = CreatorOptimizer.internalClassName(OptimizedValueInstantiator.class.getName());
        String tmpClassName = baseName.getSlashedTemplate();
        cw.visit(49, 49, tmpClassName, null, superClass, null);
        cw.visitSource(baseName.getSourceFilename(), null);
        String optimizedValueInstDesc = Type.getDescriptor(OptimizedValueInstantiator.class);
        String stdValueInstDesc = Type.getDescriptor(StdValueInstantiator.class);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + stdValueInstDesc + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, superClass, "<init>", "(" + stdValueInstDesc + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "with", "(" + stdValueInstDesc + ")" + optimizedValueInstDesc, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, tmpClassName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, tmpClassName, "<init>", "(" + stdValueInstDesc + ")V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "createUsingDefault", "(" + Type.getDescriptor(DeserializationContext.class) + ")Ljava/lang/Object;", null, null);
        mv.visitCode();
        Label startTryBlock = new Label();
        Label endTryBlock = new Label();
        Label startCatchBlock = new Label();
        mv.visitTryCatchBlock(startTryBlock, endTryBlock, startCatchBlock, "java/lang/Exception");
        mv.visitLabel(startTryBlock);
        if (ctor != null) {
            this.addCreator(mv, ctor);
        } else {
            this.addCreator(mv, factory);
        }
        mv.visitInsn(176);
        mv.visitLabel(endTryBlock);
        mv.visitLabel(startCatchBlock);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        String optimizedValueInstName = Type.getInternalName(OptimizedValueInstantiator.class);
        mv.visitMethodInsn(182, optimizedValueInstName, "_handleInstantiationProblem", String.format("(%s%s)Ljava/lang/Object;", Type.getDescriptor(DeserializationContext.class), "Ljava/lang/Exception;"), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void addCreator(MethodVisitor mv, Constructor<?> ctor) {
        Class<?> owner = ctor.getDeclaringClass();
        String valueClassInternal = Type.getInternalName(owner);
        mv.visitTypeInsn(187, valueClassInternal);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, valueClassInternal, "<init>", "()V", owner.isInterface());
    }

    protected void addCreator(MethodVisitor mv, Method factory) {
        Class<?> owner = factory.getDeclaringClass();
        Class<?> valueClass = factory.getReturnType();
        mv.visitMethodInsn(184, Type.getInternalName(owner), factory.getName(), "()" + Type.getDescriptor(valueClass), owner.isInterface());
    }
}

