/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.SpanCustomizer;
import brave.spring.webmvc.WebMvcRuntime;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.method.HandlerMethod;

public class HandlerParser {
    public static final HandlerParser NOOP = new HandlerParser(){

        @Override
        protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer2) {
        }
    };
    public static final String CONTROLLER_CLASS = "mvc.controller.class";
    public static final String CONTROLLER_METHOD = "mvc.controller.method";

    protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer2) {
        if (WebMvcRuntime.get().isHandlerMethod(handler)) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            customizer2.tag(CONTROLLER_CLASS, handlerMethod.getBeanType().getSimpleName());
            customizer2.tag(CONTROLLER_METHOD, handlerMethod.getMethod().getName());
        } else {
            customizer2.tag(CONTROLLER_CLASS, handler.getClass().getSimpleName());
        }
    }
}

