/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.spring.rabbit.SpringRabbitTracing;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class TracingRabbitListenerAdvice
implements MethodInterceptor {
    final SpringRabbitTracing springRabbitTracing;
    final Tracing tracing;
    final Tracer tracer;
    @Nullable
    final String remoteServiceName;

    TracingRabbitListenerAdvice(SpringRabbitTracing springRabbitTracing) {
        this.springRabbitTracing = springRabbitTracing;
        this.tracing = springRabbitTracing.tracing;
        this.tracer = this.tracing.tracer();
        this.remoteServiceName = springRabbitTracing.remoteServiceName;
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Message message = (Message)methodInvocation.getArguments()[1];
        TraceContextOrSamplingFlags extracted = this.springRabbitTracing.extractAndClearHeaders(message);
        Span consumerSpan = this.tracer.nextSpan(extracted);
        Span listenerSpan = this.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            this.setConsumerSpan(consumerSpan, message.getMessageProperties());
            long timestamp = this.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        try {
            Tracer.SpanInScope ws = this.tracer.withSpanInScope(listenerSpan);
            try {
                Object object = methodInvocation.proceed();
                if (ws != null) {
                    ws.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    listenerSpan.error(t);
                    throw t;
                }
            }
        }
        finally {
            listenerSpan.finish();
        }
    }

    void setConsumerSpan(Span span, MessageProperties properties) {
        span.name("next-message").kind(Span.Kind.CONSUMER);
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.exchange", properties.getReceivedExchange());
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.routing_key", properties.getReceivedRoutingKey());
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.queue", properties.getConsumerQueue());
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
    }

    static void maybeTag(Span span, String tag, String value) {
        if (value != null) {
            span.tag(tag, value);
        }
    }
}

