/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.springframework.amqp.core.MessageProperties;

final class SpringRabbitPropagation {
    static final TraceContext TEST_CONTEXT = TraceContext.newBuilder().traceId(1L).spanId(1L).build();
    static final MessageProperties B3_SINGLE_TEST_HEADERS = new MessageProperties();
    static final TraceContext.Injector<MessageProperties> B3_SINGLE_INJECTOR;
    static final Propagation.Setter<MessageProperties, String> SETTER;
    static final Propagation.Getter<MessageProperties, String> GETTER;

    SpringRabbitPropagation() {
    }

    static {
        B3_SINGLE_TEST_HEADERS.setHeader("b3", (Object)B3SingleFormat.writeB3SingleFormat(TEST_CONTEXT));
        B3_SINGLE_INJECTOR = new TraceContext.Injector<MessageProperties>(){

            @Override
            public void inject(TraceContext traceContext, MessageProperties carrier) {
                carrier.setHeader("b3", (Object)B3SingleFormat.writeB3SingleFormatWithoutParentId(traceContext));
            }

            public String toString() {
                return "MessageProperties::setHeader(\"b3\",singleHeaderFormatWithoutParent)";
            }
        };
        SETTER = new Propagation.Setter<MessageProperties, String>(){

            @Override
            public void put(MessageProperties carrier, String key, String value) {
                carrier.setHeader(key, (Object)value);
            }

            public String toString() {
                return "MessageProperties::setHeader";
            }
        };
        GETTER = new Propagation.Getter<MessageProperties, String>(){

            @Override
            public String get(MessageProperties carrier, String key) {
                return (String)carrier.getHeaders().get(key);
            }

            public String toString() {
                return "MessageProperties::setHeader";
            }
        };
    }
}

