/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.result.ScanResult;
import xyz.capybara.clamav.exceptions.InvalidResponseException;
import xyz.capybara.clamav.exceptions.ScanFailureException;

public abstract class ScanCommand
extends Command<ScanResult> {
    private static final Pattern RESPONSE_OK = Pattern.compile("(.+) OK$", 1);
    private static final Pattern RESPONSE_VIRUS_FOUND = Pattern.compile("(.+) FOUND$", 0);
    private static final Pattern RESPONSE_ERROR = Pattern.compile("(.+) ERROR", 1);
    private static final Pattern RESPONSE_VIRUS_FOUND_LINE = Pattern.compile("(.+: )?(?<filePath>.+): (?<virus>.+) FOUND$", 1);

    @Override
    protected ScanResult parseResponse(String responseString) {
        try {
            if (RESPONSE_OK.matcher(responseString).matches()) {
                return new ScanResult(ScanResult.Status.OK);
            }
            if (RESPONSE_VIRUS_FOUND.matcher(responseString).find()) {
                Map<String, Collection<String>> foundViruses = Arrays.stream(responseString.split("\n")).map(line -> {
                    Matcher matcher = RESPONSE_VIRUS_FOUND_LINE.matcher((CharSequence)line);
                    if (!matcher.matches()) {
                        throw new InvalidResponseException(responseString);
                    }
                    return new VirusInfo(matcher.group("filePath"), matcher.group("virus"));
                }).collect(new VirusInfoCollector());
                return new ScanResult(ScanResult.Status.VIRUS_FOUND, foundViruses);
            }
            if (RESPONSE_ERROR.matcher(responseString).matches()) {
                throw new ScanFailureException(responseString);
            }
        }
        catch (IllegalStateException e) {
            throw new InvalidResponseException(responseString);
        }
        throw new InvalidResponseException(responseString);
    }

    private class VirusInfoCollector
    implements Collector<VirusInfo, Map<String, Collection<String>>, Map<String, Collection<String>>> {
        private VirusInfoCollector() {
        }

        @Override
        public Supplier<Map<String, Collection<String>>> supplier() {
            return HashMap::new;
        }

        @Override
        public BiConsumer<Map<String, Collection<String>>, VirusInfo> accumulator() {
            return (map, virusInfo) -> map.computeIfAbsent(virusInfo.getFilePath(), key -> new ArrayList()).add(virusInfo.getName());
        }

        @Override
        public BinaryOperator<Map<String, Collection<String>>> combiner() {
            return (left, right) -> {
                right.forEach((file, viruses) -> viruses.forEach(name -> left.computeIfAbsent(file, key -> new ArrayList()).add(name)));
                return left;
            };
        }

        @Override
        public Function<Map<String, Collection<String>>, Map<String, Collection<String>>> finisher() {
            return map -> map;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        }
    }

    private class VirusInfo {
        private String filePath;
        private String name;

        public String getFilePath() {
            return this.filePath;
        }

        public String getName() {
            return this.name;
        }

        @ConstructorProperties(value={"filePath", "name"})
        public VirusInfo(String filePath, String name) {
            this.filePath = filePath;
            this.name = name;
        }
    }
}

