/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.capybara.clamav.exceptions.CommunicationException;
import xyz.capybara.clamav.exceptions.UnknownCommandException;

public abstract class Command<T> {
    private static final Logger log = LoggerFactory.getLogger(Command.class);
    private static final String UNKNOWN_COMMAND = "UNKNOWN COMMAND";

    public abstract String getCommandString();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T send(InetSocketAddress server) {
        try (SocketChannel socketChannel = SocketChannel.open(server);){
            socketChannel.write(this.getRawCommand());
            T t = this.readResponse(socketChannel);
            return t;
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    protected abstract CommandFormat getFormat();

    protected ByteBuffer getRawCommand() {
        StringBuilder rawCommand = new StringBuilder();
        rawCommand.append(this.getFormat().getPrefix()).append(this.getCommandString()).append(this.getFormat().getTerminator());
        return ByteBuffer.wrap(rawCommand.toString().getBytes(StandardCharsets.US_ASCII));
    }

    protected T readResponse(SocketChannel socketChannel) throws IOException {
        StringBuilder responseStringBuilder = new StringBuilder();
        ByteBuffer rawResponsePart = ByteBuffer.allocate(32);
        int read = socketChannel.read(rawResponsePart);
        while (read > -1) {
            String rawResponsePartString = new String(rawResponsePart.array(), StandardCharsets.US_ASCII);
            rawResponsePartString = rawResponsePartString.substring(0, read);
            responseStringBuilder.append(rawResponsePartString);
            rawResponsePart = ByteBuffer.allocate(32);
            read = socketChannel.read(rawResponsePart);
        }
        String responseString = this.removeResponseTerminator(responseStringBuilder.toString());
        if (responseString.equals(UNKNOWN_COMMAND)) {
            throw new UnknownCommandException(this.getCommandString());
        }
        log.debug("{} - Response: {}", (Object)this.getCommandString(), (Object)responseString);
        return this.parseResponse(responseString);
    }

    private String removeResponseTerminator(String responseString) {
        return responseString.substring(0, responseString.lastIndexOf(this.getFormat().getTerminator()));
    }

    protected abstract T parseResponse(String var1);

    public static enum CommandFormat {
        NULL_CHAR('z', '\u0000'),
        NEW_LINE('n', '\n');

        private char prefix;
        private char terminator;

        private CommandFormat(char prefix, char terminator) {
            this.prefix = prefix;
            this.terminator = terminator;
        }

        public static CommandFormat fromPrefix(char prefix) {
            CommandFormat format = null;
            switch (prefix) {
                case 'z': {
                    format = NULL_CHAR;
                    break;
                }
                case 'n': {
                    format = NEW_LINE;
                }
            }
            return format;
        }

        public char getPrefix() {
            return this.prefix;
        }

        public char getTerminator() {
            return this.terminator;
        }
    }
}

