/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.Ping;
import xyz.capybara.clamav.commands.Reload;
import xyz.capybara.clamav.commands.Shutdown;
import xyz.capybara.clamav.commands.Stats;
import xyz.capybara.clamav.commands.Version;
import xyz.capybara.clamav.commands.VersionCommands;
import xyz.capybara.clamav.commands.scan.ContScan;
import xyz.capybara.clamav.commands.scan.InStream;
import xyz.capybara.clamav.commands.scan.MultiScan;
import xyz.capybara.clamav.commands.scan.Scan;
import xyz.capybara.clamav.commands.scan.result.ScanResult;
import xyz.capybara.clamav.configuration.Platform;
import xyz.capybara.clamav.exceptions.ClamavException;
import xyz.capybara.clamav.exceptions.UnsupportedCommandException;

public class ClamavClient {
    public static final int DEFAULT_SERVER_PORT = 3310;
    public static final Platform DEFAULT_SERVER_PLATFORM = Platform.JVM_PLATFORM;
    private InetSocketAddress server;
    private Platform serverPlatform;
    private Collection<String> availableCommands;

    public ClamavClient(String serverHostname) {
        this(serverHostname, 3310);
    }

    public ClamavClient(String serverHostname, int serverPort) {
        this(serverHostname, serverPort, DEFAULT_SERVER_PLATFORM);
    }

    public ClamavClient(String serverHostname, Platform serverPlatform) {
        this(serverHostname, 3310, serverPlatform);
    }

    public ClamavClient(String serverHostname, int serverPort, Platform serverPlatform) {
        this(new InetSocketAddress(serverHostname, serverPort), serverPlatform);
    }

    public ClamavClient(InetSocketAddress server) {
        this(server, DEFAULT_SERVER_PLATFORM);
    }

    public ClamavClient(InetSocketAddress server, Platform serverPlatform) {
        this.server = server;
        this.serverPlatform = serverPlatform;
    }

    public void ping() throws ClamavException {
        this.sendCommand(new Ping());
    }

    public String version() throws ClamavException {
        return this.sendCommand(new Version());
    }

    public String stats() throws ClamavException {
        return this.sendCommand(new Stats());
    }

    public void reloadVirusDatabases() throws ClamavException {
        this.sendCommand(new Reload());
    }

    public void shutdownServer() throws ClamavException {
        this.sendCommand(new Shutdown());
    }

    public ScanResult scan(InputStream inputStream) throws ClamavException {
        return this.sendCommand(new InStream(inputStream));
    }

    public ScanResult scan(Path path) throws ClamavException {
        return this.scan(path, false);
    }

    public ScanResult scan(Path path, boolean continueScan) throws ClamavException {
        if (continueScan) {
            return this.sendCommand(new ContScan(this.serverPlatform.toServerPath(path)));
        }
        return this.sendCommand(new Scan(this.serverPlatform.toServerPath(path)));
    }

    public ScanResult parallelScan(Path path) throws ClamavException {
        return this.sendCommand(new MultiScan(this.serverPlatform.toServerPath(path)));
    }

    private Collection<String> getAvailableCommands() {
        if (this.availableCommands == null) {
            this.availableCommands = (Collection)new VersionCommands().send(this.server);
        }
        return this.availableCommands;
    }

    private <T> T sendCommand(Command<T> command) throws ClamavException {
        try {
            if (this.getAvailableCommands() != null && this.getAvailableCommands().contains(command.getCommandString())) {
                return command.send(this.server);
            }
            throw new UnsupportedCommandException(command.getCommandString());
        }
        catch (Exception cause) {
            throw new ClamavException(cause);
        }
    }

    public InetSocketAddress getServer() {
        return this.server;
    }

    public Platform getServerPlatform() {
        return this.serverPlatform;
    }
}

