/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;

public class HeaderResultMatchers {
    protected HeaderResultMatchers() {
    }

    public ResultMatcher string(String name, Matcher<? super String> matcher) {
        return result -> MatcherAssert.assertThat("Response header '" + name + "'", result.getResponse().getHeader(name), matcher);
    }

    public <T> ResultMatcher stringValues(String name, Matcher<Iterable<String>> matcher) {
        return result -> {
            Collection values = result.getResponse().getHeaders(name);
            MatcherAssert.assertThat("Response header '" + name + "'", values, matcher);
        };
    }

    public ResultMatcher string(String name, String value) {
        return result -> AssertionErrors.assertEquals("Response header '" + name + "'", value, result.getResponse().getHeader(name));
    }

    public ResultMatcher stringValues(String name, String ... values) {
        return result -> {
            List<Object> actual = result.getResponse().getHeaderValues(name);
            AssertionErrors.assertEquals("Response header '" + name + "'", Arrays.asList(values), actual);
        };
    }

    public ResultMatcher exists(String name) {
        return result -> AssertionErrors.assertTrue("Response should contain header '" + name + "'", result.getResponse().containsHeader(name));
    }

    public ResultMatcher doesNotExist(String name) {
        return result -> AssertionErrors.assertTrue("Response should not contain header '" + name + "'", !result.getResponse().containsHeader(name));
    }

    public ResultMatcher longValue(String name, long value) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            AssertionErrors.assertTrue("Response does not contain header '" + name + "'", response.containsHeader(name));
            String headerValue = response.getHeader(name);
            if (headerValue != null) {
                AssertionErrors.assertEquals("Response header '" + name + "'", value, Long.parseLong(headerValue));
            }
        };
    }

    public ResultMatcher dateValue(String name, long value) {
        return result -> {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String formatted = format.format(new Date(value));
            MockHttpServletResponse response = result.getResponse();
            AssertionErrors.assertTrue("Response does not contain header '" + name + "'", response.containsHeader(name));
            AssertionErrors.assertEquals("Response header '" + name + "'", formatted, response.getHeader(name));
        };
    }
}

