/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

public class HandlerResultMatchers {
    protected HandlerResultMatchers() {
    }

    public ResultMatcher handlerType(Class<?> type) {
        return result -> {
            Object handler = result.getHandler();
            AssertionErrors.assertTrue("No handler", handler != null);
            if (handler != null) {
                Class<?> actual = handler.getClass();
                if (HandlerMethod.class.isInstance(handler)) {
                    actual = ((HandlerMethod)handler).getBeanType();
                }
                AssertionErrors.assertEquals("Handler type", type, ClassUtils.getUserClass(actual));
            }
        };
    }

    public ResultMatcher methodCall(Object obj) {
        return result -> {
            if (!(obj instanceof MvcUriComponentsBuilder.MethodInvocationInfo)) {
                AssertionErrors.fail(String.format("The supplied object [%s] is not an instance of %s. Ensure that you invoke the handler method via MvcUriComponentsBuilder.on().", obj, MvcUriComponentsBuilder.MethodInvocationInfo.class.getName()));
            }
            MvcUriComponentsBuilder.MethodInvocationInfo invocationInfo = (MvcUriComponentsBuilder.MethodInvocationInfo)obj;
            Method expected = invocationInfo.getControllerMethod();
            Method actual = HandlerResultMatchers.getHandlerMethod(result).getMethod();
            AssertionErrors.assertEquals("Handler method", expected, actual);
        };
    }

    public ResultMatcher methodName(Matcher<? super String> matcher) {
        return result -> {
            HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
            MatcherAssert.assertThat("Handler method", handlerMethod.getMethod().getName(), matcher);
        };
    }

    public ResultMatcher methodName(String name) {
        return result -> {
            HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
            AssertionErrors.assertEquals("Handler method", name, handlerMethod.getMethod().getName());
        };
    }

    public ResultMatcher method(Method method) {
        return result -> {
            HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
            AssertionErrors.assertEquals("Handler method", method, handlerMethod.getMethod());
        };
    }

    private static HandlerMethod getHandlerMethod(MvcResult result) {
        Object handler = result.getHandler();
        AssertionErrors.assertTrue("No handler", handler != null);
        if (!(handler instanceof HandlerMethod)) {
            AssertionErrors.fail("Not a HandlerMethod: " + handler);
        }
        return (HandlerMethod)handler;
    }
}

