/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;

public class HeaderAssertions {
    private final ExchangeResult exchangeResult;
    private final WebTestClient.ResponseSpec responseSpec;

    HeaderAssertions(ExchangeResult result, WebTestClient.ResponseSpec spec) {
        this.exchangeResult = result;
        this.responseSpec = spec;
    }

    public WebTestClient.ResponseSpec valueEquals(String headerName, String ... values) {
        return this.assertHeader(headerName, Arrays.asList(values), this.getHeaders().get(headerName));
    }

    public WebTestClient.ResponseSpec valueMatches(String name, String pattern) {
        String value = this.getHeaders().getFirst(name);
        if (value == null) {
            AssertionErrors.fail(this.getMessage(name) + " not found");
        }
        boolean match = Pattern.compile(pattern).matcher(value).matches();
        String message = this.getMessage(name) + "=[" + value + "] does not match [" + pattern + "]";
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, match));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec exists(String name) {
        if (!this.getHeaders().containsKey(name)) {
            String message = this.getMessage(name) + " does not exist";
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec doesNotExist(String name) {
        if (this.getHeaders().containsKey(name)) {
            String message = this.getMessage(name) + " exists with value=[" + this.getHeaders().getFirst(name) + "]";
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec cacheControl(CacheControl cacheControl) {
        return this.assertHeader("Cache-Control", cacheControl.getHeaderValue(), this.getHeaders().getCacheControl());
    }

    public WebTestClient.ResponseSpec contentDisposition(ContentDisposition contentDisposition) {
        return this.assertHeader("Content-Disposition", contentDisposition, this.getHeaders().getContentDisposition());
    }

    public WebTestClient.ResponseSpec contentLength(long contentLength) {
        return this.assertHeader("Content-Length", contentLength, this.getHeaders().getContentLength());
    }

    public WebTestClient.ResponseSpec contentType(MediaType mediaType) {
        return this.assertHeader("Content-Type", mediaType, this.getHeaders().getContentType());
    }

    public WebTestClient.ResponseSpec contentType(String mediaType) {
        return this.contentType(MediaType.parseMediaType(mediaType));
    }

    public WebTestClient.ResponseSpec contentTypeCompatibleWith(MediaType mediaType) {
        MediaType actual = this.getHeaders().getContentType();
        String message = this.getMessage("Content-Type") + "=[" + actual + "] is not compatible with [" + mediaType + "]";
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual != null && actual.isCompatibleWith(mediaType)));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec contentTypeCompatibleWith(String mediaType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType(mediaType));
    }

    public WebTestClient.ResponseSpec expires(int expires) {
        return this.assertHeader("Expires", expires, this.getHeaders().getExpires());
    }

    public WebTestClient.ResponseSpec lastModified(int lastModified) {
        return this.assertHeader("Last-Modified", lastModified, this.getHeaders().getLastModified());
    }

    private HttpHeaders getHeaders() {
        return this.exchangeResult.getResponseHeaders();
    }

    private String getMessage(String headerName) {
        return "Response header '" + headerName + "'";
    }

    private WebTestClient.ResponseSpec assertHeader(String name, @Nullable Object expected, @Nullable Object actual) {
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals(this.getMessage(name), expected, actual));
        return this.responseSpec;
    }
}

