/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.client.MockAsyncClientHttpRequest;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.test.web.client.UnorderedRequestExpectationManager;
import org.springframework.util.Assert;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestGatewaySupport;

public class MockRestServiceServer {
    private final RequestExpectationManager expectationManager;

    private MockRestServiceServer(RequestExpectationManager expectationManager) {
        this.expectationManager = expectationManager;
    }

    public ResponseActions expect(RequestMatcher matcher) {
        return this.expect(ExpectedCount.once(), matcher);
    }

    public ResponseActions expect(ExpectedCount count, RequestMatcher matcher) {
        return this.expectationManager.expectRequest(count, matcher);
    }

    public void verify() {
        this.expectationManager.verify();
    }

    public void reset() {
        this.expectationManager.reset();
    }

    public static MockRestServiceServerBuilder bindTo(RestTemplate restTemplate) {
        return new DefaultBuilder(restTemplate);
    }

    @Deprecated
    public static MockRestServiceServerBuilder bindTo(AsyncRestTemplate asyncRestTemplate) {
        return new DefaultBuilder(asyncRestTemplate);
    }

    public static MockRestServiceServerBuilder bindTo(RestGatewaySupport restGateway) {
        Assert.notNull((Object)restGateway, "'gatewaySupport' must not be null");
        return new DefaultBuilder(restGateway.getRestTemplate());
    }

    public static MockRestServiceServer createServer(RestTemplate restTemplate) {
        return MockRestServiceServer.bindTo(restTemplate).build();
    }

    @Deprecated
    public static MockRestServiceServer createServer(AsyncRestTemplate asyncRestTemplate) {
        return MockRestServiceServer.bindTo(asyncRestTemplate).build();
    }

    public static MockRestServiceServer createServer(RestGatewaySupport restGateway) {
        return MockRestServiceServer.bindTo(restGateway).build();
    }

    private class MockClientHttpRequestFactory
    implements ClientHttpRequestFactory,
    AsyncClientHttpRequestFactory {
        private MockClientHttpRequestFactory() {
        }

        @Override
        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
            return this.createRequestInternal(uri, httpMethod);
        }

        @Override
        public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) {
            return this.createRequestInternal(uri, httpMethod);
        }

        private MockAsyncClientHttpRequest createRequestInternal(URI uri, HttpMethod method) {
            Assert.notNull((Object)uri, "'uri' must not be null");
            Assert.notNull((Object)method, "'httpMethod' must not be null");
            return new MockAsyncClientHttpRequest(method, uri){

                @Override
                protected ClientHttpResponse executeInternal() throws IOException {
                    ClientHttpResponse response = MockRestServiceServer.this.expectationManager.validateRequest(this);
                    this.setResponse(response);
                    return response;
                }
            };
        }
    }

    private static class DefaultBuilder
    implements MockRestServiceServerBuilder {
        @Nullable
        private final RestTemplate restTemplate;
        @Nullable
        private final AsyncRestTemplate asyncRestTemplate;
        private boolean ignoreExpectOrder;
        private boolean bufferContent;

        public DefaultBuilder(RestTemplate restTemplate) {
            Assert.notNull((Object)restTemplate, "RestTemplate must not be null");
            this.restTemplate = restTemplate;
            this.asyncRestTemplate = null;
        }

        public DefaultBuilder(AsyncRestTemplate asyncRestTemplate) {
            Assert.notNull((Object)asyncRestTemplate, "AsyncRestTemplate must not be null");
            this.restTemplate = null;
            this.asyncRestTemplate = asyncRestTemplate;
        }

        @Override
        public MockRestServiceServerBuilder ignoreExpectOrder(boolean ignoreExpectOrder) {
            this.ignoreExpectOrder = ignoreExpectOrder;
            return this;
        }

        @Override
        public MockRestServiceServerBuilder bufferContent() {
            this.bufferContent = true;
            return this;
        }

        @Override
        public MockRestServiceServer build() {
            if (this.ignoreExpectOrder) {
                return this.build(new UnorderedRequestExpectationManager());
            }
            return this.build(new SimpleRequestExpectationManager());
        }

        @Override
        public MockRestServiceServer build(RequestExpectationManager manager) {
            MockRestServiceServer server;
            MockRestServiceServer mockRestServiceServer = server = new MockRestServiceServer(manager);
            mockRestServiceServer.getClass();
            MockClientHttpRequestFactory factory = mockRestServiceServer.new MockClientHttpRequestFactory();
            if (this.restTemplate != null) {
                if (this.bufferContent) {
                    this.restTemplate.setRequestFactory(new BufferingClientHttpRequestFactory(factory));
                } else {
                    this.restTemplate.setRequestFactory(factory);
                }
            }
            if (this.asyncRestTemplate != null) {
                this.asyncRestTemplate.setAsyncRequestFactory(factory);
            }
            return server;
        }
    }

    public static interface MockRestServiceServerBuilder {
        public MockRestServiceServerBuilder ignoreExpectOrder(boolean var1);

        public MockRestServiceServerBuilder bufferContent();

        public MockRestServiceServer build();

        public MockRestServiceServer build(RequestExpectationManager var1);
    }
}

