/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.test.web.client.DefaultRequestExpectation;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;

public abstract class AbstractRequestExpectationManager
implements RequestExpectationManager {
    private final List<RequestExpectation> expectations = new LinkedList<RequestExpectation>();
    private final List<ClientHttpRequest> requests = new LinkedList<ClientHttpRequest>();

    protected List<RequestExpectation> getExpectations() {
        return Collections.unmodifiableList(this.expectations);
    }

    protected List<ClientHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    @Override
    public ResponseActions expectRequest(ExpectedCount count, RequestMatcher matcher) {
        Assert.state(this.requests.isEmpty(), "Cannot add more expectations after actual requests are made");
        DefaultRequestExpectation expectation = new DefaultRequestExpectation(count, matcher);
        this.expectations.add(expectation);
        return expectation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientHttpResponse validateRequest(ClientHttpRequest request) throws IOException {
        RequestExpectation expectation = null;
        List<ClientHttpRequest> list = this.requests;
        synchronized (list) {
            if (this.requests.isEmpty()) {
                this.afterExpectationsDeclared();
            }
            try {
                ClientHttpResponse response = this.validateRequestInternal(request);
                if (response != null) {
                    ClientHttpResponse clientHttpResponse = response;
                    return clientHttpResponse;
                }
                expectation = this.matchRequest(request);
            }
            finally {
                this.requests.add(request);
            }
            return expectation.createResponse(request);
        }
    }

    protected void afterExpectationsDeclared() {
    }

    @Deprecated
    @Nullable
    protected ClientHttpResponse validateRequestInternal(ClientHttpRequest request) throws IOException {
        return null;
    }

    protected RequestExpectation matchRequest(ClientHttpRequest request) throws IOException {
        throw new UnsupportedOperationException("It looks like neither the deprecated \"validateRequestInternal\"nor its replacement (this method) are implemented.");
    }

    @Override
    public void verify() {
        if (this.expectations.isEmpty()) {
            return;
        }
        int count = 0;
        for (RequestExpectation expectation : this.expectations) {
            if (expectation.isSatisfied()) continue;
            ++count;
        }
        if (count > 0) {
            String message = "Further request(s) expected leaving " + count + " unsatisfied expectation(s).\n";
            throw new AssertionError((Object)(message + this.getRequestDetails()));
        }
    }

    protected String getRequestDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requests.size()).append(" request(s) executed");
        if (!this.requests.isEmpty()) {
            sb.append(":\n");
            for (ClientHttpRequest request : this.requests) {
                sb.append(request.toString()).append("\n");
            }
        } else {
            sb.append(".\n");
        }
        return sb.toString();
    }

    protected AssertionError createUnexpectedRequestError(ClientHttpRequest request) {
        HttpMethod method = request.getMethod();
        URI uri = request.getURI();
        String message = "No further requests expected: HTTP " + (Object)((Object)method) + " " + uri + "\n";
        return new AssertionError((Object)(message + this.getRequestDetails()));
    }

    @Override
    public void reset() {
        this.expectations.clear();
        this.requests.clear();
    }

    protected static class RequestExpectationGroup {
        private final Set<RequestExpectation> expectations = new LinkedHashSet<RequestExpectation>();

        protected RequestExpectationGroup() {
        }

        public void addAllExpectations(Collection<RequestExpectation> expectations) {
            this.expectations.addAll(expectations);
        }

        public Set<RequestExpectation> getExpectations() {
            return this.expectations;
        }

        @Nullable
        public RequestExpectation findExpectation(ClientHttpRequest request) throws IOException {
            for (RequestExpectation expectation : this.expectations) {
                try {
                    expectation.match(request);
                    return expectation;
                }
                catch (AssertionError assertionError) {
                }
            }
            return null;
        }

        public void update(RequestExpectation expectation) {
            expectation.incrementAndValidate();
            this.updateInternal(expectation);
        }

        private void updateInternal(RequestExpectation expectation) {
            if (expectation.hasRemainingCount()) {
                this.expectations.add(expectation);
            } else {
                this.expectations.remove(expectation);
            }
        }

        @Deprecated
        public void updateAll(Collection<RequestExpectation> expectations) {
            expectations.forEach(this::updateInternal);
        }

        public void reset() {
            this.expectations.clear();
        }
    }
}

