/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XpathExpectationsHelper {
    private final String expression;
    private final XPathExpression xpathExpression;
    private final boolean hasNamespaces;

    public XpathExpectationsHelper(String expression, @Nullable Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.expression = String.format(expression, args);
        this.xpathExpression = this.compileXpathExpression(this.expression, namespaces);
        this.hasNamespaces = !CollectionUtils.isEmpty(namespaces);
    }

    private XPathExpression compileXpathExpression(String expression, @Nullable Map<String, String> namespaces) throws XPathExpressionException {
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(namespaces != null ? namespaces : Collections.emptyMap());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(namespaceContext);
        return xpath.compile(expression);
    }

    protected XPathExpression getXpathExpression() {
        return this.xpathExpression;
    }

    public void assertNode(byte[] content, @Nullable String encoding, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        Node node = this.evaluateXpath(document, XPathConstants.NODE, Node.class);
        MatcherAssert.assertThat("XPath " + this.expression, node, matcher);
    }

    protected Document parseXmlByteArray(byte[] xml, @Nullable String encoding) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(this.hasNamespaces);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml));
        if (StringUtils.hasText(encoding)) {
            inputSource.setEncoding(encoding);
        }
        return documentBuilder.parse(inputSource);
    }

    @Nullable
    protected <T> T evaluateXpath(Document document, QName evaluationType, Class<T> expectedClass) throws XPathExpressionException {
        return (T)this.getXpathExpression().evaluate(document, evaluationType);
    }

    public void exists(byte[] content, @Nullable String encoding) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        Node node = this.evaluateXpath(document, XPathConstants.NODE, Node.class);
        AssertionErrors.assertTrue("XPath " + this.expression + " does not exist", node != null);
    }

    public void doesNotExist(byte[] content, @Nullable String encoding) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        Node node = this.evaluateXpath(document, XPathConstants.NODE, Node.class);
        AssertionErrors.assertTrue("XPath " + this.expression + " exists", node == null);
    }

    public void assertNodeCount(byte[] content, @Nullable String encoding, Matcher<Integer> matcher) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        NodeList nodeList = this.evaluateXpath(document, XPathConstants.NODESET, NodeList.class);
        MatcherAssert.assertThat("nodeCount for XPath " + this.expression, nodeList != null ? nodeList.getLength() : 0, matcher);
    }

    public void assertNodeCount(byte[] content, @Nullable String encoding, int expectedCount) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        NodeList nodeList = this.evaluateXpath(document, XPathConstants.NODESET, NodeList.class);
        AssertionErrors.assertEquals("nodeCount for XPath " + this.expression, expectedCount, nodeList != null ? nodeList.getLength() : 0);
    }

    public void assertString(byte[] content, @Nullable String encoding, Matcher<? super String> matcher) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        String result = this.evaluateXpath(document, XPathConstants.STRING, String.class);
        MatcherAssert.assertThat("XPath " + this.expression, result, matcher);
    }

    public void assertString(byte[] content, @Nullable String encoding, String expectedValue) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        String actual = this.evaluateXpath(document, XPathConstants.STRING, String.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, actual);
    }

    public void assertNumber(byte[] content, @Nullable String encoding, Matcher<? super Double> matcher) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        Double result = this.evaluateXpath(document, XPathConstants.NUMBER, Double.class);
        MatcherAssert.assertThat("XPath " + this.expression, result, matcher);
    }

    public void assertNumber(byte[] content, @Nullable String encoding, Double expectedValue) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        Double actual = this.evaluateXpath(document, XPathConstants.NUMBER, Double.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, actual);
    }

    public void assertBoolean(byte[] content, @Nullable String encoding, boolean expectedValue) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        String actual = this.evaluateXpath(document, XPathConstants.STRING, String.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, Boolean.parseBoolean(actual));
    }
}

