/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import org.junit.runners.model.Statement;
import org.springframework.test.annotation.TestAnnotationUtils;
import org.springframework.util.Assert;

public class SpringFailOnTimeout
extends Statement {
    private final Statement next;
    private final long timeout;

    public SpringFailOnTimeout(Statement next, Method testMethod) {
        this(next, TestAnnotationUtils.getTimeout(testMethod));
    }

    public SpringFailOnTimeout(Statement next, long timeout) {
        Assert.notNull((Object)next, "next statement must not be null");
        Assert.isTrue(timeout >= 0L, "timeout must be non-negative");
        this.next = next;
        this.timeout = timeout;
    }

    @Override
    public void evaluate() throws Throwable {
        if (this.timeout == 0L) {
            this.next.evaluate();
        } else {
            long startTime = System.currentTimeMillis();
            this.next.evaluate();
            long elapsed = System.currentTimeMillis() - startTime;
            if (elapsed > this.timeout) {
                throw new TimeoutException(String.format("Test took %s ms; limit was %s ms.", elapsed, this.timeout));
            }
        }
    }
}

