/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CompositeServerHttpHeadersWriter
implements ServerHttpHeadersWriter {
    private final List<ServerHttpHeadersWriter> writers;

    public CompositeServerHttpHeadersWriter(ServerHttpHeadersWriter ... writers) {
        this(Arrays.asList(writers));
    }

    public CompositeServerHttpHeadersWriter(List<ServerHttpHeadersWriter> writers) {
        this.writers = writers;
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange2) {
        Stream<Mono> results = this.writers.stream().map(writer -> writer.writeHttpHeaders(exchange2));
        return Mono.when((Iterable)results.collect(Collectors.toList()));
    }
}

