/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionServerSecurityContextRepository
implements ServerSecurityContextRepository {
    public static final String DEFAULT_SPRING_SECURITY_CONTEXT_ATTR_NAME = "SPRING_SECURITY_CONTEXT";
    private String springSecurityContextAttrName = "SPRING_SECURITY_CONTEXT";

    public void setSpringSecurityContextAttrName(String springSecurityContextAttrName) {
        Assert.hasText(springSecurityContextAttrName, "springSecurityContextAttrName cannot be null or empty");
        this.springSecurityContextAttrName = springSecurityContextAttrName;
    }

    @Override
    public Mono<Void> save(ServerWebExchange exchange2, SecurityContext context) {
        return exchange2.getSession().doOnNext(session -> {
            if (context == null) {
                session.getAttributes().remove(this.springSecurityContextAttrName);
            } else {
                session.getAttributes().put(this.springSecurityContextAttrName, context);
            }
        }).flatMap(session -> session.changeSessionId());
    }

    @Override
    public Mono<SecurityContext> load(ServerWebExchange exchange2) {
        return exchange2.getSession().map(WebSession::getAttributes).flatMap(attrs -> {
            SecurityContext context = (SecurityContext)attrs.get(this.springSecurityContextAttrName);
            return Mono.justOrEmpty((Object)context);
        });
    }
}

