/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.websphere.DefaultWASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WebSpherePreAuthenticatedWebAuthenticationDetailsSource;

public class WebSpherePreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final WASUsernameAndGroupsExtractor wasHelper;

    public WebSpherePreAuthenticatedProcessingFilter() {
        this(new DefaultWASUsernameAndGroupsExtractor());
    }

    WebSpherePreAuthenticatedProcessingFilter(WASUsernameAndGroupsExtractor wasHelper) {
        this.wasHelper = wasHelper;
        this.setAuthenticationDetailsSource(new WebSpherePreAuthenticatedWebAuthenticationDetailsSource());
    }

    @Override
    protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
        String principal = this.wasHelper.getCurrentUserName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PreAuthenticated WebSphere principal: " + principal);
        }
        return principal;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest httpRequest) {
        return "N/A";
    }
}

