/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ContextPathCompositeHandler
implements HttpHandler {
    private final Map<String, HttpHandler> handlerMap;

    public ContextPathCompositeHandler(Map<String, ? extends HttpHandler> handlerMap) {
        Assert.notEmpty(handlerMap, "Handler map must not be empty");
        this.handlerMap = ContextPathCompositeHandler.initHandlers(handlerMap);
    }

    private static Map<String, HttpHandler> initHandlers(Map<String, ? extends HttpHandler> map) {
        map.keySet().forEach(ContextPathCompositeHandler::assertValidContextPath);
        return new LinkedHashMap<String, HttpHandler>(map);
    }

    private static void assertValidContextPath(String contextPath) {
        Assert.hasText(contextPath, "Context path must not be empty");
        if (contextPath.equals("/")) {
            return;
        }
        Assert.isTrue(contextPath.startsWith("/"), "Context path must begin with '/'");
        Assert.isTrue(!contextPath.endsWith("/"), "Context path must not end with '/'");
    }

    @Override
    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        String path = request.getPath().pathWithinApplication().value();
        return this.handlerMap.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).findFirst().map(entry -> {
            String contextPath = request.getPath().contextPath().value() + (String)entry.getKey();
            ServerHttpRequest newRequest = request.mutate().contextPath(contextPath).build();
            return ((HttpHandler)entry.getValue()).handle(newRequest, response);
        }).orElseGet(() -> {
            response.setStatusCode(HttpStatus.NOT_FOUND);
            response.setComplete();
            return Mono.empty();
        });
    }
}

