/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.MapDataBinder;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;

public class ProxyingHandlerMethodArgumentResolver
extends ModelAttributeMethodProcessor
implements BeanFactoryAware,
BeanClassLoaderAware {
    private static final List<String> IGNORED_PACKAGES = Arrays.asList("java", "org.springframework");
    private final SpelAwareProxyProjectionFactory proxyFactory = new SpelAwareProxyProjectionFactory();
    private final ObjectFactory<ConversionService> conversionService;

    @Deprecated
    public ProxyingHandlerMethodArgumentResolver(ConversionService conversionService) {
        this(() -> conversionService, true);
    }

    public ProxyingHandlerMethodArgumentResolver(ObjectFactory<ConversionService> conversionService, boolean annotationNotRequired) {
        super(annotationNotRequired);
        this.conversionService = conversionService;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.proxyFactory.setBeanFactory(beanFactory);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.proxyFactory.setBeanClassLoader(classLoader);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (!super.supportsParameter(parameter)) {
            return false;
        }
        Class<?> type = parameter.getParameterType();
        if (!type.isInterface()) {
            return false;
        }
        if (parameter.getParameterAnnotation(ProjectedPayload.class) != null) {
            return true;
        }
        if (AnnotatedElementUtils.findMergedAnnotation(type, ProjectedPayload.class) != null) {
            return true;
        }
        String packageName = ClassUtils.getPackageName(type);
        return !IGNORED_PACKAGES.stream().anyMatch(it -> packageName.startsWith((String)it));
    }

    @Override
    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        MapDataBinder binder = new MapDataBinder(parameter.getParameterType(), this.conversionService.getObject());
        binder.bind(new MutablePropertyValues(request.getParameterMap()));
        return this.proxyFactory.createProjection((Class)parameter.getParameterType(), binder.getTarget());
    }

    @Override
    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
    }
}

