/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.lang.Nullable;

class QueryExecutionResultHandler {
    private static final TypeDescriptor WRAPPER_TYPE = TypeDescriptor.valueOf(NullableWrapper.class);
    private final GenericConversionService conversionService;

    public QueryExecutionResultHandler() {
        DefaultConversionService conversionService = new DefaultConversionService();
        QueryExecutionConverters.registerConvertersIn(conversionService);
        this.conversionService = conversionService;
    }

    @Nullable
    public Object postProcessInvocationResult(@Nullable Object result, Method method) {
        if (method.getReturnType().isInstance(result)) {
            return result;
        }
        MethodParameter parameter = new MethodParameter(method, -1);
        TypeDescriptor methodReturnTypeDescriptor = TypeDescriptor.nested(parameter, 0);
        return this.postProcessInvocationResult(result, methodReturnTypeDescriptor);
    }

    @Nullable
    Object postProcessInvocationResult(@Nullable Object result, @Nullable TypeDescriptor returnTypeDescriptor) {
        if (returnTypeDescriptor == null) {
            return result;
        }
        Class<?> expectedReturnType = returnTypeDescriptor.getType();
        if (result != null && expectedReturnType.isInstance(result)) {
            return result;
        }
        if ((result = QueryExecutionResultHandler.unwrapOptional(result)) != null && expectedReturnType.isInstance(result)) {
            return result;
        }
        if (QueryExecutionConverters.supports(expectedReturnType)) {
            TypeDescriptor targetType = TypeDescriptor.valueOf(expectedReturnType);
            if (this.conversionService.canConvert(WRAPPER_TYPE, returnTypeDescriptor) && !this.conversionService.canBypassConvert(WRAPPER_TYPE, targetType)) {
                return this.conversionService.convert((Object)new NullableWrapper(result), expectedReturnType);
            }
            if (result != null && this.conversionService.canConvert(TypeDescriptor.valueOf(result.getClass()), returnTypeDescriptor) && !this.conversionService.canBypassConvert(TypeDescriptor.valueOf(result.getClass()), targetType)) {
                return this.conversionService.convert(result, expectedReturnType);
            }
        }
        if (result != null) {
            if (ReactiveWrapperConverters.supports(expectedReturnType)) {
                return ReactiveWrapperConverters.toWrapper(result, expectedReturnType);
            }
            return this.conversionService.canConvert(result.getClass(), expectedReturnType) ? this.conversionService.convert(result, expectedReturnType) : result;
        }
        return Map.class.equals(expectedReturnType) ? CollectionFactory.createMap(expectedReturnType, 0) : null;
    }

    @Nullable
    private static Object unwrapOptional(@Nullable Object source) {
        if (source == null) {
            return null;
        }
        return Optional.class.isInstance(source) ? ((Optional)Optional.class.cast(source)).orElse(null) : source;
    }
}

