/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.Nullable;

public class PersistableEntityInformation<T extends Persistable<ID>, ID>
extends AbstractEntityInformation<T, ID> {
    private Class<ID> idClass;

    public PersistableEntityInformation(Class<T> domainClass) {
        super(domainClass);
        Class<?> idClass = ResolvableType.forClass(Persistable.class, domainClass).resolveGeneric(0);
        if (idClass == null) {
            throw new IllegalArgumentException(String.format("Could not resolve identifier type for %s!", domainClass));
        }
        this.idClass = idClass;
    }

    @Override
    public boolean isNew(T entity) {
        return entity.isNew();
    }

    @Override
    @Nullable
    public ID getId(T entity) {
        return entity.getId();
    }

    @Override
    public Class<ID> getIdType() {
        return this.idClass;
    }
}

