/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class DefaultMethodInvokingMethodInterceptor
implements MethodInterceptor {
    private final MethodHandleLookup methodHandleLookup = MethodHandleLookup.getMethodHandleLookup();
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentReferenceHashMap<Method, MethodHandle>(10, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    @Override
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isDefault()) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object proxy = ((ProxyMethodInvocation)invocation).getProxy();
        return this.getMethodHandle(method).bindTo(proxy).invokeWithArguments(arguments);
    }

    private MethodHandle getMethodHandle(Method method) throws Exception {
        MethodHandle handle = this.methodHandleCache.get(method);
        if (handle == null) {
            handle = this.methodHandleLookup.lookup(method);
            this.methodHandleCache.put(method, handle);
        }
        return handle;
    }

    static enum MethodHandleLookup {
        OPEN{
            private final Optional<Constructor<MethodHandles.Lookup>> constructor = MethodHandleLookup.access$100();

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                Constructor<MethodHandles.Lookup> constructor = this.constructor.orElseThrow(() -> new IllegalStateException("Could not obtain MethodHandles.lookup constructor"));
                return constructor.newInstance(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass());
            }

            @Override
            boolean isAvailable() {
                return this.constructor.isPresent();
            }
        }
        ,
        ENCAPSULATED{
            @Nullable
            private final Method privateLookupIn = ReflectionUtils.findMethod(MethodHandles.class, "privateLookupIn", Class.class, MethodHandles.Lookup.class);

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                return this.getLookup(method.getDeclaringClass(), this.privateLookupIn).findSpecial(method.getDeclaringClass(), method.getName(), methodType, method.getDeclaringClass());
            }

            @Override
            boolean isAvailable() {
                return true;
            }

            private MethodHandles.Lookup getLookup(Class<?> declaringClass, @Nullable Method privateLookupIn) {
                if (privateLookupIn == null) {
                    return MethodHandles.lookup();
                }
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                try {
                    return (MethodHandles.Lookup)privateLookupIn.invoke(MethodHandles.class, declaringClass, lookup);
                }
                catch (ReflectiveOperationException e) {
                    return lookup;
                }
            }
        };


        abstract MethodHandle lookup(Method var1) throws ReflectiveOperationException;

        abstract boolean isAvailable();

        public static MethodHandleLookup getMethodHandleLookup() {
            return Arrays.stream(MethodHandleLookup.values()).filter(it -> it.isAvailable()).findFirst().orElseThrow(() -> new IllegalStateException("No MethodHandleLookup available!"));
        }

        private static Optional<Constructor<MethodHandles.Lookup>> getLookupConstructor() {
            try {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                ReflectionUtils.makeAccessible(constructor);
                return Optional.of(constructor);
            }
            catch (Exception ex) {
                if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    return Optional.empty();
                }
                throw new IllegalStateException(ex);
            }
        }

        static /* synthetic */ Optional access$100() {
            return MethodHandleLookup.getLookupConstructor();
        }
    }
}

