/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultPersistentPropertyPath<P extends PersistentProperty<P>>
implements PersistentPropertyPath<P> {
    private static final Converter<PersistentProperty<?>, String> DEFAULT_CONVERTER = source -> source.getName();
    private static final String DEFAULT_DELIMITER = ".";
    private final List<P> properties;

    public DefaultPersistentPropertyPath(List<P> properties) {
        Assert.notNull(properties, "Properties must not be null!");
        this.properties = properties;
    }

    public static <T extends PersistentProperty<T>> DefaultPersistentPropertyPath<T> empty() {
        return new DefaultPersistentPropertyPath(Collections.emptyList());
    }

    public DefaultPersistentPropertyPath<P> append(P property) {
        Assert.notNull(property, "Property must not be null!");
        if (this.isEmpty()) {
            return new DefaultPersistentPropertyPath<P>(Collections.singletonList(property));
        }
        Class<?> leafPropertyType = this.getLeafProperty().getActualType();
        Assert.isTrue(property.getOwner().getType().equals(leafPropertyType), String.format("Cannot append property %s to type %s!", property.getName(), leafPropertyType.getName()));
        ArrayList<P> properties = new ArrayList<P>(this.properties);
        properties.add(property);
        return new DefaultPersistentPropertyPath<P>(properties);
    }

    @Override
    @Nullable
    public String toDotPath() {
        return this.toPath(DEFAULT_DELIMITER, (Converter<? super P, String>)DEFAULT_CONVERTER);
    }

    @Override
    @Nullable
    public String toDotPath(Converter<? super P, String> converter) {
        return this.toPath(DEFAULT_DELIMITER, converter);
    }

    @Override
    @Nullable
    public String toPath(String delimiter) {
        return this.toPath(delimiter, (Converter<? super P, String>)DEFAULT_CONVERTER);
    }

    @Override
    @Nullable
    public String toPath(String delimiter, Converter<? super P, String> converter) {
        Assert.hasText(delimiter, "Delimiter must not be null or empty!");
        Assert.notNull(converter, "Converter must not be null!");
        ArrayList<String> result = new ArrayList<String>();
        for (PersistentProperty property : this.properties) {
            String convert = converter.convert(property);
            if (!StringUtils.hasText(convert)) continue;
            result.add(convert);
        }
        return result.isEmpty() ? null : StringUtils.collectionToDelimitedString(result, delimiter);
    }

    @Override
    @Nullable
    public P getLeafProperty() {
        return (P)((PersistentProperty)this.properties.get(this.properties.size() - 1));
    }

    @Override
    @Nullable
    public P getBaseProperty() {
        return (P)((PersistentProperty)this.properties.get(0));
    }

    @Override
    public boolean isBasePathOf(PersistentPropertyPath<P> path) {
        Assert.notNull(path, "PersistentPropertyPath must not be null!");
        Iterator iterator = path.iterator();
        for (PersistentProperty property : this) {
            if (!iterator.hasNext()) {
                return false;
            }
            PersistentProperty reference = (PersistentProperty)iterator.next();
            if (property.equals(reference)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PersistentPropertyPath<P> getExtensionForBaseOf(PersistentPropertyPath<P> base) {
        if (!base.isBasePathOf(this)) {
            return this;
        }
        ArrayList<P> result = new ArrayList<P>();
        Iterator<P> iterator = this.iterator();
        for (int i = 0; i < base.getLength(); ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return new DefaultPersistentPropertyPath(result);
    }

    @Override
    public PersistentPropertyPath<P> getParentPath() {
        int size = this.properties.size();
        if (size <= 1) {
            return this;
        }
        return new DefaultPersistentPropertyPath<P>(this.properties.subList(0, size - 1));
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public Iterator<P> iterator() {
        return this.properties.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultPersistentPropertyPath that = (DefaultPersistentPropertyPath)obj;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    @Nullable
    public String toString() {
        return this.toDotPath();
    }
}

