/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PreferredConstructor<T, P extends PersistentProperty<P>> {
    private final Constructor<T> constructor;
    private final List<Parameter<Object, P>> parameters;
    private final Map<PersistentProperty<?>, Boolean> isPropertyParameterCache = new HashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    @SafeVarargs
    public PreferredConstructor(Constructor<T> constructor, Parameter<Object, P> ... parameters) {
        Assert.notNull(constructor, "Constructor must not be null!");
        Assert.notNull(parameters, "Parameters must not be null!");
        ReflectionUtils.makeAccessible(constructor);
        this.constructor = constructor;
        this.parameters = Arrays.asList(parameters);
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public List<Parameter<Object, P>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isNoArgConstructor() {
        return this.parameters.isEmpty();
    }

    public boolean isExplicitlyAnnotated() {
        return this.constructor.isAnnotationPresent(PersistenceConstructor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConstructorParameter(PersistentProperty<?> property) {
        Assert.notNull(property, "Property must not be null!");
        try {
            this.read.lock();
            Boolean cached = this.isPropertyParameterCache.get(property);
            if (cached != null) {
                boolean bl = cached;
                return bl;
            }
        }
        finally {
            this.read.unlock();
        }
        try {
            this.write.lock();
            for (Parameter<Object, P> parameter : this.parameters) {
                if (!parameter.maps(property)) continue;
                this.isPropertyParameterCache.put(property, true);
                boolean bl = true;
                return bl;
            }
            this.isPropertyParameterCache.put(property, false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    public boolean isEnclosingClassParameter(Parameter<?, P> parameter) {
        Assert.notNull(parameter, "Parameter must not be null!");
        if (this.parameters.isEmpty() || !((Parameter)parameter).isEnclosingClassParameter()) {
            return false;
        }
        return this.parameters.get(0).equals(parameter);
    }

    public static class Parameter<T, P extends PersistentProperty<P>> {
        @Nullable
        private final String name;
        private final TypeInformation<T> type;
        private final String key;
        @Nullable
        private final PersistentEntity<T, P> entity;
        private final Lazy<Boolean> enclosingClassCache;
        private final Lazy<Boolean> hasSpelExpression;

        public Parameter(@Nullable String name, TypeInformation<T> type, Annotation[] annotations, @Nullable PersistentEntity<T, P> entity) {
            Assert.notNull(type, "Type must not be null!");
            Assert.notNull((Object)annotations, "Annotations must not be null!");
            this.name = name;
            this.type = type;
            this.key = Parameter.getValue(annotations);
            this.entity = entity;
            this.enclosingClassCache = Lazy.of(() -> {
                if (entity == null) {
                    throw new IllegalStateException();
                }
                Class owningType = entity.getType();
                return owningType.isMemberClass() && type.getType().equals(owningType.getEnclosingClass());
            });
            this.hasSpelExpression = Lazy.of(() -> StringUtils.hasText(this.getSpelExpression()));
        }

        private static String getValue(Annotation[] annotations) {
            return Arrays.stream(annotations).filter(it -> it.annotationType() == Value.class).findFirst().map(it -> ((Value)it).value()).filter(StringUtils::hasText).orElse(null);
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public TypeInformation<T> getType() {
            return this.type;
        }

        public Class<T> getRawType() {
            return this.type.getType();
        }

        public String getSpelExpression() {
            return this.key;
        }

        public boolean hasSpelExpression() {
            return this.hasSpelExpression.get();
        }

        boolean maps(PersistentProperty<?> property) {
            PersistentEntity<T, P> entity = this.entity;
            String name = this.name;
            Object referencedProperty = entity == null ? null : (name == null ? null : entity.getPersistentProperty(name));
            return property != null && property.equals(referencedProperty);
        }

        private boolean isEnclosingClassParameter() {
            return this.enclosingClassCache.get();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            TypeInformation<T> this$type = this.getType();
            TypeInformation<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$key = this.key;
            String other$key = other.key;
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            PersistentEntity<T, P> this$entity = this.entity;
            PersistentEntity<T, P> other$entity = other.entity;
            return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            TypeInformation<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $key = this.key;
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            PersistentEntity<T, P> $entity = this.entity;
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            return result;
        }
    }
}

