/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureAttributes {
    static final String SYNTHETIC_OUTPUT_PARAMETER_NAME = "out";
    private final boolean namedStoredProcedure;
    private final String procedureName;
    private final String outputParameterName;
    private final Class<?> outputParameterType;

    public StoredProcedureAttributes(String procedureName, @Nullable String outputParameterName, Class<?> outputParameterType, boolean namedStoredProcedure) {
        Assert.notNull((Object)procedureName, "ProcedureName must not be null!");
        Assert.notNull(outputParameterType, "OutputParameterType must not be null!");
        this.procedureName = procedureName;
        this.outputParameterName = !namedStoredProcedure && !StringUtils.hasText(outputParameterName) ? SYNTHETIC_OUTPUT_PARAMETER_NAME : outputParameterName;
        this.outputParameterType = outputParameterType;
        this.namedStoredProcedure = namedStoredProcedure;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getOutputParameterName() {
        return this.outputParameterName;
    }

    public Class<?> getOutputParameterType() {
        return this.outputParameterType;
    }

    public boolean isNamedStoredProcedure() {
        return this.namedStoredProcedure;
    }

    public boolean hasReturnValue() {
        return !Void.TYPE.equals(this.outputParameterType) && !Void.class.equals(this.outputParameterType);
    }
}

