/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;

final class NativeJpaQuery
extends AbstractStringBasedJpaQuery {
    private final Class<?> resultType;

    public NativeJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em, queryString, evaluationContextProvider, parser);
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter() && !queryString.contains("#sort")) {
            throw new InvalidJpaQueryMethodException("Cannot use native queries with dynamic sorting in method " + method);
        }
        this.resultType = this.getTypeToQueryFor();
    }

    @Override
    protected Query createJpaQuery(String queryString) {
        EntityManager em = this.getEntityManager();
        return this.resultType == null ? em.createNativeQuery(queryString) : em.createNativeQuery(queryString, this.resultType);
    }

    @Nullable
    private Class<?> getTypeToQueryFor() {
        Class<?> result;
        ResultProcessor resultFactory = this.getQueryMethod().getResultProcessor();
        ReturnedType returnedType = resultFactory.getReturnedType();
        Class<?> clazz = result = this.getQueryMethod().isQueryForEntity() ? returnedType.getDomainType() : null;
        if (this.getQuery().hasConstructorExpression() || this.getQuery().isDefaultProjection()) {
            return result;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : result;
    }
}

