/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final DeclaredQuery query;
    private final DeclaredQuery countQuery;
    private final EvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText(queryString, "Query string must not be null or empty!");
        Assert.notNull((Object)evaluationContextProvider, "ExpressionEvaluationContextProvider must not be null!");
        Assert.notNull((Object)parser, "Parser must not be null or empty!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser);
        this.countQuery = this.query.deriveCountQuery(method.getCountQuery(), method.getCountQueryProjection());
        this.parser = parser;
        Assert.isTrue(method.isNativeQuery() || !this.query.usesJdbcStyleParameters(), "JDBC style parameters (?) are not supported for JPA queries.");
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        Query query2 = this.createJpaQuery(sortedQueryString);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query2, values);
    }

    @Override
    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), this.query, this.parser, this.evaluationContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(Object[] values) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        TypedQuery<Long> query2 = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        return ((ParameterBinder)this.parameterBinder.get()).bind(query2, values, QueryParameterSetter.ErrorHandling.LENIENT);
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public DeclaredQuery getCountQuery() {
        return this.countQuery;
    }

    protected Query createJpaQuery(String queryString) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        return this.getTypeToRead().map(it -> em.createQuery(queryString, it)).orElseGet(() -> em.createQuery(queryString));
    }
}

