/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationRevisionMetadata<N extends Number>
implements RevisionMetadata<N> {
    private final Object entity;
    private final Lazy<Optional<N>> revisionNumber;
    private final Lazy<Optional<Object>> revisionDate;

    public AnnotationRevisionMetadata(Object entity, Class<? extends Annotation> revisionNumberAnnotation, Class<? extends Annotation> revisionTimeStampAnnotation) {
        Assert.notNull(entity, "Entity must not be null!");
        Assert.notNull(revisionNumberAnnotation, "Revision number annotation must not be null!");
        Assert.notNull(revisionTimeStampAnnotation, "Revision time stamp annotation must not be null!");
        this.entity = entity;
        this.revisionNumber = AnnotationRevisionMetadata.detectAnnotation(entity, revisionNumberAnnotation);
        this.revisionDate = AnnotationRevisionMetadata.detectAnnotation(entity, revisionTimeStampAnnotation);
    }

    @Override
    public Optional<N> getRevisionNumber() {
        return this.revisionNumber.get();
    }

    @Override
    public Optional<LocalDateTime> getRevisionDate() {
        return this.revisionDate.get().map(AnnotationRevisionMetadata::convertToLocalDateTime);
    }

    @Override
    public <T> T getDelegate() {
        return (T)this.entity;
    }

    private static <T> Lazy<Optional<T>> detectAnnotation(Object entity, Class<? extends Annotation> annotationType) {
        return Lazy.of(() -> {
            AnnotationDetectionFieldCallback callback = new AnnotationDetectionFieldCallback(annotationType);
            ReflectionUtils.doWithFields(entity.getClass(), callback);
            return Optional.ofNullable(callback.getValue(entity));
        });
    }

    private static LocalDateTime convertToLocalDateTime(Object timestamp) {
        if (timestamp instanceof LocalDateTime) {
            return (LocalDateTime)timestamp;
        }
        return LocalDateTime.ofInstant(AnnotationRevisionMetadata.convertToInstant(timestamp), ZoneOffset.systemDefault());
    }

    private static Instant convertToInstant(Object timestamp) {
        if (timestamp instanceof Instant) {
            return (Instant)timestamp;
        }
        if (timestamp instanceof LocalDateTime) {
            return ((LocalDateTime)timestamp).atZone(ZoneOffset.systemDefault()).toInstant();
        }
        if (timestamp instanceof Long) {
            return Instant.ofEpochMilli((Long)timestamp);
        }
        throw new IllegalArgumentException(String.format("Can't convert %s to Instant!", timestamp));
    }
}

