/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.data.domain.TypedExampleMatcher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ExampleMatcher {
    public static ExampleMatcher matching() {
        return ExampleMatcher.matchingAll();
    }

    public static ExampleMatcher matchingAny() {
        return new TypedExampleMatcher().withMode(MatchMode.ANY);
    }

    public static ExampleMatcher matchingAll() {
        return new TypedExampleMatcher().withMode(MatchMode.ALL);
    }

    public ExampleMatcher withIgnorePaths(String ... var1);

    public ExampleMatcher withStringMatcher(StringMatcher var1);

    default public ExampleMatcher withIgnoreCase() {
        return this.withIgnoreCase(true);
    }

    public ExampleMatcher withIgnoreCase(boolean var1);

    default public ExampleMatcher withMatcher(String propertyPath, MatcherConfigurer<GenericPropertyMatcher> matcherConfigurer) {
        Assert.hasText(propertyPath, "PropertyPath must not be empty!");
        Assert.notNull(matcherConfigurer, "MatcherConfigurer must not be empty!");
        GenericPropertyMatcher genericPropertyMatcher = new GenericPropertyMatcher();
        matcherConfigurer.configureMatcher(genericPropertyMatcher);
        return this.withMatcher(propertyPath, genericPropertyMatcher);
    }

    public ExampleMatcher withMatcher(String var1, GenericPropertyMatcher var2);

    public ExampleMatcher withTransformer(String var1, PropertyValueTransformer var2);

    public ExampleMatcher withIgnoreCase(String ... var1);

    default public ExampleMatcher withIncludeNullValues() {
        return this.withNullHandler(NullHandler.INCLUDE);
    }

    default public ExampleMatcher withIgnoreNullValues() {
        return this.withNullHandler(NullHandler.IGNORE);
    }

    public ExampleMatcher withNullHandler(NullHandler var1);

    public NullHandler getNullHandler();

    public StringMatcher getDefaultStringMatcher();

    public boolean isIgnoreCaseEnabled();

    default public boolean isIgnoredPath(String path) {
        return this.getIgnoredPaths().contains(path);
    }

    public Set<String> getIgnoredPaths();

    public PropertySpecifiers getPropertySpecifiers();

    default public boolean isAllMatching() {
        return this.getMatchMode().equals((Object)MatchMode.ALL);
    }

    default public boolean isAnyMatching() {
        return this.getMatchMode().equals((Object)MatchMode.ANY);
    }

    public MatchMode getMatchMode();

    public static enum MatchMode {
        ALL,
        ANY;

    }

    public static class PropertySpecifiers {
        private final Map<String, PropertySpecifier> propertySpecifiers = new LinkedHashMap<String, PropertySpecifier>();

        PropertySpecifiers() {
        }

        PropertySpecifiers(PropertySpecifiers propertySpecifiers) {
            this.propertySpecifiers.putAll(propertySpecifiers.propertySpecifiers);
        }

        public void add(PropertySpecifier specifier) {
            Assert.notNull((Object)specifier, "PropertySpecifier must not be null!");
            this.propertySpecifiers.put(specifier.getPath(), specifier);
        }

        public boolean hasSpecifierForPath(String path) {
            return this.propertySpecifiers.containsKey(path);
        }

        public PropertySpecifier getForPath(String path) {
            return this.propertySpecifiers.get(path);
        }

        public boolean hasValues() {
            return !this.propertySpecifiers.isEmpty();
        }

        public Collection<PropertySpecifier> getSpecifiers() {
            return this.propertySpecifiers.values();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertySpecifiers)) {
                return false;
            }
            PropertySpecifiers other = (PropertySpecifiers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, PropertySpecifier> this$propertySpecifiers = this.propertySpecifiers;
            Map<String, PropertySpecifier> other$propertySpecifiers = other.propertySpecifiers;
            return !(this$propertySpecifiers == null ? other$propertySpecifiers != null : !((Object)this$propertySpecifiers).equals(other$propertySpecifiers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertySpecifiers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, PropertySpecifier> $propertySpecifiers = this.propertySpecifiers;
            result = result * 59 + ($propertySpecifiers == null ? 43 : ((Object)$propertySpecifiers).hashCode());
            return result;
        }
    }

    public static class PropertySpecifier {
        private final String path;
        @Nullable
        private final StringMatcher stringMatcher;
        @Nullable
        private final Boolean ignoreCase;
        private final PropertyValueTransformer valueTransformer;

        PropertySpecifier(String path) {
            Assert.hasText(path, "Path must not be null/empty!");
            this.path = path;
            this.stringMatcher = null;
            this.ignoreCase = null;
            this.valueTransformer = NoOpPropertyValueTransformer.INSTANCE;
        }

        public PropertySpecifier withStringMatcher(StringMatcher stringMatcher) {
            Assert.notNull((Object)stringMatcher, "StringMatcher must not be null!");
            return new PropertySpecifier(this.path, stringMatcher, this.ignoreCase, this.valueTransformer);
        }

        public PropertySpecifier withIgnoreCase(boolean ignoreCase) {
            return new PropertySpecifier(this.path, this.stringMatcher, ignoreCase, this.valueTransformer);
        }

        public PropertySpecifier withValueTransformer(PropertyValueTransformer valueTransformer) {
            Assert.notNull((Object)valueTransformer, "PropertyValueTransformer must not be null!");
            return new PropertySpecifier(this.path, this.stringMatcher, this.ignoreCase, valueTransformer);
        }

        public String getPath() {
            return this.path;
        }

        @Nullable
        public StringMatcher getStringMatcher() {
            return this.stringMatcher;
        }

        @Nullable
        public Boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public PropertyValueTransformer getPropertyValueTransformer() {
            return this.valueTransformer == null ? NoOpPropertyValueTransformer.INSTANCE : this.valueTransformer;
        }

        @Deprecated
        public Object transformValue(Object source) {
            return this.transformValue(Optional.ofNullable(source)).orElse(null);
        }

        public Optional<Object> transformValue(Optional<Object> source) {
            return (Optional)this.getPropertyValueTransformer().apply(source);
        }

        private PropertySpecifier(String path, @Nullable StringMatcher stringMatcher, @Nullable Boolean ignoreCase, PropertyValueTransformer valueTransformer) {
            this.path = path;
            this.stringMatcher = stringMatcher;
            this.ignoreCase = ignoreCase;
            this.valueTransformer = valueTransformer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertySpecifier)) {
                return false;
            }
            PropertySpecifier other = (PropertySpecifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            StringMatcher this$stringMatcher = this.getStringMatcher();
            StringMatcher other$stringMatcher = other.getStringMatcher();
            if (this$stringMatcher == null ? other$stringMatcher != null : !((Object)((Object)this$stringMatcher)).equals((Object)other$stringMatcher)) {
                return false;
            }
            Boolean this$ignoreCase = this.getIgnoreCase();
            Boolean other$ignoreCase = other.getIgnoreCase();
            if (this$ignoreCase == null ? other$ignoreCase != null : !((Object)this$ignoreCase).equals(other$ignoreCase)) {
                return false;
            }
            PropertyValueTransformer this$valueTransformer = this.valueTransformer;
            PropertyValueTransformer other$valueTransformer = other.valueTransformer;
            return !(this$valueTransformer == null ? other$valueTransformer != null : !this$valueTransformer.equals(other$valueTransformer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertySpecifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            StringMatcher $stringMatcher = this.getStringMatcher();
            result = result * 59 + ($stringMatcher == null ? 43 : ((Object)((Object)$stringMatcher)).hashCode());
            Boolean $ignoreCase = this.getIgnoreCase();
            result = result * 59 + ($ignoreCase == null ? 43 : ((Object)$ignoreCase).hashCode());
            PropertyValueTransformer $valueTransformer = this.valueTransformer;
            result = result * 59 + ($valueTransformer == null ? 43 : $valueTransformer.hashCode());
            return result;
        }
    }

    public static enum NoOpPropertyValueTransformer implements PropertyValueTransformer
    {
        INSTANCE;


        @Override
        public Optional<Object> apply(Optional<Object> source) {
            return source;
        }
    }

    public static interface PropertyValueTransformer
    extends Function<Optional<Object>, Optional<Object>> {
        @Deprecated
        default public Object convert(Object source) {
            return ((Optional)this.apply(Optional.ofNullable(source))).orElse(null);
        }
    }

    public static enum StringMatcher {
        DEFAULT,
        EXACT,
        STARTING,
        ENDING,
        CONTAINING,
        REGEX;

    }

    public static class GenericPropertyMatchers {
        public static GenericPropertyMatcher ignoreCase() {
            return new GenericPropertyMatcher().ignoreCase();
        }

        public static GenericPropertyMatcher caseSensitive() {
            return new GenericPropertyMatcher().caseSensitive();
        }

        public static GenericPropertyMatcher contains() {
            return new GenericPropertyMatcher().contains();
        }

        public static GenericPropertyMatcher endsWith() {
            return new GenericPropertyMatcher().endsWith();
        }

        public static GenericPropertyMatcher startsWith() {
            return new GenericPropertyMatcher().startsWith();
        }

        public static GenericPropertyMatcher exact() {
            return new GenericPropertyMatcher().exact();
        }

        public static GenericPropertyMatcher storeDefaultMatching() {
            return new GenericPropertyMatcher().storeDefaultMatching();
        }

        public static GenericPropertyMatcher regex() {
            return new GenericPropertyMatcher().regex();
        }
    }

    public static class GenericPropertyMatcher {
        @Nullable
        StringMatcher stringMatcher = null;
        @Nullable
        Boolean ignoreCase = null;
        PropertyValueTransformer valueTransformer = NoOpPropertyValueTransformer.INSTANCE;

        public static GenericPropertyMatcher of(StringMatcher stringMatcher, boolean ignoreCase) {
            return new GenericPropertyMatcher().stringMatcher(stringMatcher).ignoreCase(ignoreCase);
        }

        public static GenericPropertyMatcher of(StringMatcher stringMatcher) {
            return new GenericPropertyMatcher().stringMatcher(stringMatcher);
        }

        public GenericPropertyMatcher ignoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public GenericPropertyMatcher ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public GenericPropertyMatcher caseSensitive() {
            this.ignoreCase = false;
            return this;
        }

        public GenericPropertyMatcher contains() {
            this.stringMatcher = StringMatcher.CONTAINING;
            return this;
        }

        public GenericPropertyMatcher endsWith() {
            this.stringMatcher = StringMatcher.ENDING;
            return this;
        }

        public GenericPropertyMatcher startsWith() {
            this.stringMatcher = StringMatcher.STARTING;
            return this;
        }

        public GenericPropertyMatcher exact() {
            this.stringMatcher = StringMatcher.EXACT;
            return this;
        }

        public GenericPropertyMatcher storeDefaultMatching() {
            this.stringMatcher = StringMatcher.DEFAULT;
            return this;
        }

        public GenericPropertyMatcher regex() {
            this.stringMatcher = StringMatcher.REGEX;
            return this;
        }

        public GenericPropertyMatcher stringMatcher(StringMatcher stringMatcher) {
            Assert.notNull((Object)stringMatcher, "StringMatcher must not be null!");
            this.stringMatcher = stringMatcher;
            return this;
        }

        public GenericPropertyMatcher transform(PropertyValueTransformer propertyValueTransformer) {
            Assert.notNull((Object)propertyValueTransformer, "PropertyValueTransformer must not be null!");
            this.valueTransformer = propertyValueTransformer;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericPropertyMatcher)) {
                return false;
            }
            GenericPropertyMatcher other = (GenericPropertyMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StringMatcher this$stringMatcher = this.stringMatcher;
            StringMatcher other$stringMatcher = other.stringMatcher;
            if (this$stringMatcher == null ? other$stringMatcher != null : !((Object)((Object)this$stringMatcher)).equals((Object)other$stringMatcher)) {
                return false;
            }
            Boolean this$ignoreCase = this.ignoreCase;
            Boolean other$ignoreCase = other.ignoreCase;
            if (this$ignoreCase == null ? other$ignoreCase != null : !((Object)this$ignoreCase).equals(other$ignoreCase)) {
                return false;
            }
            PropertyValueTransformer this$valueTransformer = this.valueTransformer;
            PropertyValueTransformer other$valueTransformer = other.valueTransformer;
            return !(this$valueTransformer == null ? other$valueTransformer != null : !this$valueTransformer.equals(other$valueTransformer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenericPropertyMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StringMatcher $stringMatcher = this.stringMatcher;
            result = result * 59 + ($stringMatcher == null ? 43 : ((Object)((Object)$stringMatcher)).hashCode());
            Boolean $ignoreCase = this.ignoreCase;
            result = result * 59 + ($ignoreCase == null ? 43 : ((Object)$ignoreCase).hashCode());
            PropertyValueTransformer $valueTransformer = this.valueTransformer;
            result = result * 59 + ($valueTransformer == null ? 43 : $valueTransformer.hashCode());
            return result;
        }
    }

    public static interface MatcherConfigurer<T> {
        public void configureMatcher(T var1);
    }

    public static enum NullHandler {
        INCLUDE,
        IGNORE;

    }
}

