/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import brave.spring.webmvc.SpanCustomizingAsyncHandlerInterceptor;
import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;

class TraceZuulHandlerMappingBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final BeanFactory beanFactory;

    public TraceZuulHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof ZuulHandlerMapping) {
            if (log.isDebugEnabled()) {
                log.debug("Attaching trace interceptor to bean [" + beanName + "] of type [" + bean2.getClass().getSimpleName() + "]");
            }
            ZuulHandlerMapping zuulHandlerMapping = (ZuulHandlerMapping)bean2;
            zuulHandlerMapping.setInterceptors(new Object[]{this.beanFactory.getBean(SpanCustomizingAsyncHandlerInterceptor.class)});
        }
        return bean2;
    }
}

