/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceLoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.util.ClassUtils;

final class TraceFeignObjectWrapper {
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private Object springClientFactory;
    private static final boolean ribbonPresent = ClassUtils.isPresent("org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient", null) && ClassUtils.isPresent("org.springframework.cloud.netflix.ribbon.SpringClientFactory", null);

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean2) {
        if (bean2 instanceof Client && !(bean2 instanceof TracingFeignClient)) {
            if (ribbonPresent && bean2 instanceof LoadBalancerFeignClient && !(bean2 instanceof TraceLoadBalancerFeignClient)) {
                LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean2;
                return new TraceLoadBalancerFeignClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
            }
            if (ribbonPresent && bean2 instanceof TraceLoadBalancerFeignClient) {
                return bean2;
            }
            return new LazyTracingFeignClient(this.beanFactory, (Client)bean2);
        }
        return bean2;
    }

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    private Object clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }
}

