/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

@Aspect
class TraceFeignAspect {
    private static final Log log = LogFactory.getLog(TraceFeignAspect.class);
    private final BeanFactory beanFactory;

    TraceFeignAspect(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Around(value="execution (* feign.Client.*(..)) && !within(is(FinalType))")
    public Object feignClientWasCalled(ProceedingJoinPoint pjp) throws Throwable {
        Object bean2 = pjp.getTarget();
        Object wrappedBean = new TraceFeignObjectWrapper(this.beanFactory).wrap(bean2);
        if (log.isDebugEnabled()) {
            log.debug("Executing feign client via TraceFeignAspect");
        }
        if (bean2 != wrappedBean) {
            return this.executeTraceFeignClient(bean2, pjp);
        }
        return pjp.proceed();
    }

    Object executeTraceFeignClient(Object bean2, ProceedingJoinPoint pjp) throws IOException {
        Object[] args = pjp.getArgs();
        Request request = (Request)args[0];
        Request.Options options = (Request.Options)args[1];
        return ((Client)bean2).execute(request, options);
    }
}

