/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

class TraceWebClientBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    TraceWebClientBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof WebClient) {
            WebClient webClient = (WebClient)bean2;
            return webClient.mutate().filters(this.addTraceExchangeFilterFunctionIfNotPresent()).build();
        }
        if (bean2 instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean2;
            return webClientBuilder.filters(this.addTraceExchangeFilterFunctionIfNotPresent());
        }
        return bean2;
    }

    private Consumer<List<ExchangeFilterFunction>> addTraceExchangeFilterFunctionIfNotPresent() {
        return functions -> {
            if (functions.stream().noneMatch(f -> f instanceof TraceExchangeFilterFunction)) {
                functions.add(new TraceExchangeFilterFunction(this.beanFactory));
            }
        };
    }
}

