/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.http.HttpTracing;
import io.netty.handler.codec.http.HttpMethod;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.web.client.TracingHttpClientInstrumentation;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;

@Aspect
class NettyAspect {
    private final TracingHttpClientInstrumentation instrumentation;

    NettyAspect(HttpTracing httpTracing) {
        this.instrumentation = TracingHttpClientInstrumentation.create(httpTracing);
    }

    @Pointcut(value="execution(public * reactor.ipc.netty.http.client.HttpClient.request(..)) && args(method, url, handler)")
    private void anyHttpClientRequestSending(HttpMethod method, String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
    }

    @Around(value="anyHttpClientRequestSending(method, url, handler)")
    public Object wrapHttpClientRequestSending(ProceedingJoinPoint pjp, HttpMethod method, String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) throws Throwable {
        return Mono.defer(() -> {
            try {
                return this.instrumentation.wrapHttpClientRequestSending(pjp, method, url, handler);
            }
            catch (Throwable e) {
                return Mono.error((Throwable)e);
            }
        });
    }
}

