/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.web.ClientSampler;
import org.springframework.cloud.sleuth.instrument.web.CompositeHttpSampler;
import org.springframework.cloud.sleuth.instrument.web.ServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpLegacyProperties;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpSampler;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(name={"spring.sleuth.http.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class, SleuthHttpLegacyProperties.class})
public class TraceHttpAutoConfiguration {
    static final int TRACING_FILTER_ORDER = -2147483643;
    @Autowired
    HttpClientParser clientParser;
    @Autowired
    HttpServerParser serverParser;
    @Autowired
    @ClientSampler
    HttpSampler clientSampler;
    @Autowired(required=false)
    @ServerSampler
    HttpSampler serverSampler;

    @Bean
    @ConditionalOnMissingBean
    HttpTracing httpTracing(Tracing tracing, SkipPatternProvider provider) {
        HttpSampler serverSampler = this.combineUserProvidedSamplerWithSkipPatternSampler(provider);
        return HttpTracing.newBuilder(tracing).clientParser(this.clientParser).serverParser(this.serverParser).clientSampler(this.clientSampler).serverSampler(serverSampler).build();
    }

    private HttpSampler combineUserProvidedSamplerWithSkipPatternSampler(SkipPatternProvider provider) {
        HttpSampler serverSampler = this.serverSampler;
        SleuthHttpSampler skipPatternSampler = new SleuthHttpSampler(provider);
        if (serverSampler == null) {
            return skipPatternSampler;
        }
        return new CompositeHttpSampler(skipPatternSampler, serverSampler);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpClientParser sleuthHttpClientParser(TraceKeys traceKeys) {
        return new SleuthHttpClientParser(traceKeys);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    HttpClientParser httpClientParser(final ErrorParser errorParser) {
        return new HttpClientParser(){

            @Override
            protected ErrorParser errorParser() {
                return errorParser;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpServerParser sleuthHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        return new SleuthHttpServerParser(traceKeys, errorParser);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    HttpServerParser defaultHttpServerParser() {
        return new HttpServerParser();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthClientSampler"})
    HttpSampler sleuthClientSampler() {
        return HttpSampler.TRACE_ID;
    }
}

